/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.util.DefaultFileMarshaler;
import org.servicemix.components.util.FileMarshaler;
import org.servicemix.components.util.OutBinding;

public class FileWriter
extends OutBinding {
    private static final Log log = LogFactory.getLog((Class)FileWriter.class);
    private File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String tempFilePrefix = "servicemix-";
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    protected void init() throws JBIException {
        if (this.directory == null) {
            throw new IllegalArgumentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("The directory property must be a directory but was: " + this.directory);
        }
        super.init();
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        OutputStream out = null;
        try {
            String name = this.marshaler.getOutputName(exchange, message);
            File newFile = null;
            newFile = name == null ? File.createTempFile(this.tempFilePrefix, this.tempFileSuffix, this.directory) : new File(this.directory, name);
            out = new BufferedOutputStream(new FileOutputStream(newFile));
            this.marshaler.writeMessage(exchange, message, out, name);
            this.done(exchange);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }
}

