/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import java.net.UnknownHostException;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.servicemix.components.http.BindingServlet;
import org.servicemix.components.http.HttpInOutBinding;

public class HttpConnector
extends HttpInOutBinding {
    private SocketListener listener = new SocketListener();
    private Server server;
    private String host;
    private int port;

    public HttpConnector(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public HttpConnector() {
    }

    public HttpConnector(SocketListener listener) {
        this.listener = listener;
    }

    public void init(ComponentContext cc) throws JBIException {
        super.init(cc);
        if (this.listener == null) {
            this.listener = new SocketListener();
        }
        try {
            this.listener.setHost(this.host);
        }
        catch (UnknownHostException e) {
            throw new JBIException("init failed", (Throwable)e);
        }
        this.listener.setPort(this.port);
        this.server = new Server();
    }

    public void start() throws JBIException {
        this.server.addListener((HttpListener)this.listener);
        HttpContext context = this.server.addContext("/");
        ServletHandler handler = new ServletHandler();
        handler.addServlet("jbiServlet", "/*", BindingServlet.class.getName());
        context.addHandler((HttpHandler)handler);
        try {
            context.setAttribute("binding", (Object)this);
            this.server.start();
        }
        catch (Exception e) {
            throw new JBIException("Start failed: " + e, (Throwable)e);
        }
    }

    public void stop() throws JBIException {
        try {
            this.server.stop();
        }
        catch (InterruptedException e) {
            throw new JBIException("Stop failed: " + e, (Throwable)e);
        }
    }

    public void shutDown() throws JBIException {
        this.server = null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

