/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jabber;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.TransformerException;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.servicemix.components.jabber.JabberComponentSupport;

public class JabberChatSender
extends JabberComponentSupport {
    private Chat chat;
    private String participant;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.chat == null && this.participant == null) {
            throw new IllegalArgumentException("You must specify the participant property");
        }
    }

    public void start() throws JBIException {
        super.start();
        if (this.chat == null) {
            this.chat = this.getConnection().createChat(this.participant);
        }
    }

    public void stop() throws JBIException {
        this.chat = null;
        super.stop();
    }

    public Chat getChat() {
        return this.chat;
    }

    public void setChat(Chat chat) {
        this.chat = chat;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    protected void process(MessageExchange messageExchange, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            Message message = this.chat.createMessage();
            this.getMarshaler().fromNMS(message, normalizedMessage);
            this.chat.sendMessage(message);
            this.done(messageExchange);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (XMPPException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

