/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.mule;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.management.ObjectName;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.servicemix.components.mule.JBIConnector;
import org.servicemix.components.mule.MuleMarshaler;
import org.servicemix.jbi.FaultException;

public class JBIMessageDispatcher
extends AbstractMessageDispatcher
implements ComponentLifeCycle {
    private ObjectName extensionMBeanName;
    private JBIConnector jbiConnector;
    private MuleMarshaler marshaler = new MuleMarshaler();
    private ComponentContext context;
    private DeliveryChannel deliveryChannel;
    private MessageExchangeFactory exchangeFactory;

    public JBIMessageDispatcher(JBIConnector connector) {
        super((AbstractConnector)connector);
        this.jbiConnector = connector;
    }

    public JBIConnector getJbiConnector() {
        return this.jbiConnector;
    }

    public void setJbiConnector(JBIConnector jbiConnector) {
        this.jbiConnector = jbiConnector;
    }

    public void doDispose() {
    }

    public void doDispatch(UMOEvent event) throws Exception {
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        this.getMarshaler().populateNormalizedMessage(message, event);
        this.done((MessageExchange)exchange);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        return null;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public ObjectName getExtensionMBeanName() {
        return this.extensionMBeanName;
    }

    public void init(ComponentContext context) throws JBIException {
        this.context = context;
        this.deliveryChannel = context.getDeliveryChannel();
        this.exchangeFactory = this.deliveryChannel.createExchangeFactory();
    }

    public void shutDown() throws JBIException {
    }

    public void start() throws JBIException {
    }

    public void stop() throws JBIException {
    }

    public void setExtensionMBeanName(ObjectName extensionMBeanName) {
        this.extensionMBeanName = extensionMBeanName;
    }

    public MuleMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(MuleMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public DeliveryChannel getDeliveryChannel() {
        return this.deliveryChannel;
    }

    public MessageExchangeFactory getExchangeFactory() {
        return this.exchangeFactory;
    }

    protected void done(MessageExchange exchange) throws MessagingException {
        exchange.setStatus(ExchangeStatus.DONE);
        this.getDeliveryChannel().send(exchange);
    }

    protected void fail(MessageExchange exchange, Exception error) throws MessagingException {
        exchange.setError(error);
        if (error instanceof FaultException) {
            FaultException faultException = (FaultException)error;
            exchange.setFault(faultException.getFault());
        }
        exchange.setStatus(ExchangeStatus.ERROR);
        this.getDeliveryChannel().send(exchange);
    }
}

