/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Namespace;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.namespace.QName;
import org.servicemix.MessageExchangeListener;
import org.servicemix.components.util.ComponentSupport;
import org.springframework.core.io.Resource;

public class ScriptComponent
extends ComponentSupport
implements MessageExchangeListener {
    public static final QName SERVICE = new QName("http://servicemix.org/example/", "receiver");
    public static final String ENDPOINT = "receiver";
    private ScriptEngine engine;
    private String scriptEngineName;
    private CompiledScript compiledScript;
    private String scriptText;
    private Resource script;
    private String logResourceBundle;
    private boolean disableOutput;
    private Logger scriptLogger;
    private Map bindings = new HashMap();

    public ScriptComponent() {
        super(SERVICE, ENDPOINT);
    }

    public ScriptComponent(QName service, String endpoint) {
        super(service, endpoint);
    }

    public void start() throws JBIException {
        if (this.engine == null) {
            if (this.compiledScript != null) {
                this.engine = this.compiledScript.getEngine();
            } else {
                if (this.scriptEngineName != null) {
                    this.engine = this.createScriptEngine();
                }
                if (this.engine == null) {
                    throw new JBIException("Must be configured with either the 'compiledScript' or 'engine' property");
                }
            }
        }
        if (this.compiledScript == null) {
            this.checkScriptTextAvailable();
        }
        if (this.compiledScript == null && this.engine instanceof Compilable) {
            Compilable compilable = (Compilable)((Object)this.engine);
            this.compileScript(compilable);
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            NormalizedMessage message = exchange.getMessage("in");
            this.process(exchange, message);
        }
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public Resource getScript() {
        return this.script;
    }

    public void setScript(Resource script) {
        this.script = script;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public void setDisableOutput(boolean disableOutput) {
        this.disableOutput = disableOutput;
    }

    public String getLogResourceBundle() {
        return this.logResourceBundle;
    }

    public Map getBindings() {
        return this.bindings;
    }

    public void setBindings(Map bindings) {
        this.bindings = bindings;
    }

    public void setLogResourceBundle(String logResourceBundle) {
        this.logResourceBundle = logResourceBundle;
    }

    public Logger getScriptLogger() throws MessagingException {
        if (this.scriptLogger == null) {
            this.scriptLogger = this.createScriptLogger();
        }
        return this.scriptLogger;
    }

    public void setScriptLogger(Logger scriptLogger) {
        this.scriptLogger = scriptLogger;
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        Namespace namespace = this.engine.createNamespace();
        this.populateNamespace(namespace, exchange, message);
        try {
            this.runScript(namespace);
            if (!this.isInAndOut(exchange)) {
                if (!this.isDisableOutput()) {
                    InOnly outExchange = (InOnly)namespace.get((Object)"outExchange");
                    this.getDeliveryChannel().sendSync((MessageExchange)outExchange);
                    exchange.setStatus(ExchangeStatus.DONE);
                } else {
                    exchange.setStatus(ExchangeStatus.DONE);
                }
            }
            this.getDeliveryChannel().send(exchange);
        }
        catch (ScriptException e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
            throw new MessagingException("Failed to run compiledScript. Reason: " + e, (Throwable)e);
        }
    }

    protected void populateNamespace(Namespace namespace, MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        namespace.put((Object)"context", (Object)this.getContext());
        namespace.put((Object)"deliveryChannel", (Object)this.getDeliveryChannel());
        namespace.put((Object)"exchange", (Object)exchange);
        namespace.put((Object)"inMessage", (Object)message);
        namespace.put((Object)"log", (Object)this.getScriptLogger());
        namespace.put((Object)"componentNamespace", (Object)namespace);
        namespace.put((Object)"bindings", (Object)this.bindings);
        InOnly outExchange = null;
        if (this.isInAndOut(exchange)) {
            NormalizedMessage out = exchange.createMessage();
            exchange.setMessage(out, "out");
            namespace.put((Object)"outMessage", (Object)out);
        } else if (!this.isDisableOutput()) {
            outExchange = this.getExchangeFactory().createInOnlyExchange();
            namespace.put((Object)"outExchange", (Object)outExchange);
            NormalizedMessage out = outExchange.createMessage();
            outExchange.setInMessage(out);
            namespace.put((Object)"outMessage", (Object)out);
        }
    }

    protected Logger createScriptLogger() throws MessagingException {
        if (this.logResourceBundle != null) {
            try {
                return this.getContext().getLogger(((Object)((Object)this)).getClass().getName(), this.logResourceBundle);
            }
            catch (JBIException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        return Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void runScript(Namespace namespace) throws ScriptException {
        if (this.compiledScript != null) {
            this.compiledScript.eval(namespace);
        } else {
            this.evaluteScript(namespace);
        }
    }

    protected void evaluteScript(Namespace namespace) throws ScriptException {
        this.engine.eval(this.scriptText, namespace);
    }

    protected void compileScript(Compilable compilable) throws JBIException {
        try {
            if (this.scriptText != null) {
                this.compiledScript = compilable.compile(this.scriptText);
            } else if (this.script != null) {
                this.compiledScript = compilable.compile(new InputStreamReader(this.script.getInputStream()));
            }
        }
        catch (ScriptException e) {
            throw new JBIException("Failed to parse compiledScript. Reason:  " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new JBIException("Failed to parse compiledScript. Reason:  " + e, (Throwable)e);
        }
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        return manager.getEngineByName(this.scriptEngineName);
    }

    protected void checkScriptTextAvailable() throws JBIException {
        if (this.scriptText == null) {
            throw new JBIException("If no 'compiledScript' is specified you must specify the 'scriptText'");
        }
    }
}

