/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.vfs;

import javax.jbi.JBIException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

public class FileObjectEditor {
    private String path;
    private FileSystemManager fileSystemManager;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public FileObject getFileObject() throws JBIException {
        try {
            if (this.fileSystemManager == null) {
                this.fileSystemManager = VFS.getManager();
            }
            if (this.path == null) {
                throw new IllegalArgumentException("You must specify a path property");
            }
            FileObject answer = this.fileSystemManager.resolveFile(this.path);
            if (answer == null) {
                throw new JBIException("Could not resolve file: " + this.path);
            }
            try {
                answer.createFolder();
            }
            catch (FileSystemException e) {
                throw new JBIException("Failed to create folder: " + (Object)((Object)e), (Throwable)e);
            }
            return answer;
        }
        catch (FileSystemException e) {
            throw new JBIException("Failed to initialize file system manager: " + (Object)((Object)e), (Throwable)e);
        }
    }
}

