/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.wsif;

import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.BindingOperation;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.servicemix.components.util.ComponentSupport;
import org.servicemix.components.wsif.WSIFMarshaler;
import org.servicemix.components.wsif.WSIFOperationInfo;
import org.springframework.beans.factory.InitializingBean;

public class WSIFInBinding
extends ComponentSupport
implements InitializingBean {
    private WSIFMarshaler marshaler = new WSIFMarshaler();
    private WSIFOperationInfo operationInfo;
    private WSIFOperation wsifOperation;
    private BindingOperation bindingOperation;

    public WSIFMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(WSIFMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public boolean process(WSIFMessage wsifMessage) throws JBIException {
        InOut exchange = this.getDeliveryChannel().createExchangeFactory().createInOutExchange();
        NormalizedMessage inMessage = exchange.createMessage();
        try {
            this.marshaler.toNMS((MessageExchange)exchange, inMessage, this.operationInfo, wsifMessage);
            exchange.setInMessage(inMessage);
            if (this.getDeliveryChannel().sendSync((MessageExchange)exchange)) {
                exchange.setStatus(ExchangeStatus.DONE);
                return true;
            }
            exchange.setStatus(ExchangeStatus.ERROR);
            return false;
        }
        catch (WSIFException e) {
            exchange.setError((Exception)((Object)e));
            exchange.setStatus(ExchangeStatus.ERROR);
            return false;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.operationInfo == null) {
            if (this.wsifOperation == null) {
                throw new IllegalArgumentException("You must specify an operationInfo or wsifOperation property");
            }
            if (this.bindingOperation == null) {
                throw new IllegalArgumentException("You must specify an operationInfo or bindingOperation property");
            }
            this.operationInfo = new WSIFOperationInfo(this.wsifOperation, this.bindingOperation);
        }
    }
}

