/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.xslt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.servicemix.MessageExchangeListener;
import org.servicemix.components.util.TransformComponentSupport;
import org.servicemix.jbi.jaxp.BytesSource;
import org.servicemix.jbi.jaxp.StringSource;
import org.springframework.core.io.Resource;

public class XsltComponent
extends TransformComponentSupport
implements MessageExchangeListener {
    private TransformerFactory transformerFactory;
    private Source xsltSource;
    private Resource xsltResource;
    private Templates templates;
    private boolean disableOutput;
    private boolean useStringBuffer = true;

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Source getXsltSource() throws IOException {
        if (this.xsltSource == null) {
            return this.createXsltSource();
        }
        return this.xsltSource;
    }

    public void setXsltSource(Source xsltSource) {
        this.xsltSource = xsltSource;
    }

    public Resource getXsltResource() {
        return this.xsltResource;
    }

    public void setXsltResource(Resource xsltResource) {
        this.xsltResource = xsltResource;
    }

    public boolean isDisableOutput() {
        return this.disableOutput;
    }

    public void setDisableOutput(boolean disableOutput) {
        this.disableOutput = disableOutput;
    }

    public boolean isUseStringBuffer() {
        return this.useStringBuffer;
    }

    public void setUseStringBuffer(boolean useStringBuffer) {
        this.useStringBuffer = useStringBuffer;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        try {
            Transformer transformer = this.createTransformer(exchange, in);
            this.configureTransformer(transformer, exchange, in);
            this.copyPropertiesAndAttachments(exchange, in, out);
            this.transformContent(transformer, exchange, in, out);
            return this.shouldOutputResult(transformer);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new MessagingException("Failed to transform: " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException("Failed to load transform: " + e, (Throwable)e);
        }
    }

    protected void transformContent(Transformer transformer, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws TransformerException, MessagingException {
        if (this.isUseStringBuffer()) {
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(in.getContent(), result);
            out.setContent((Source)new StringSource(buffer.toString()));
        } else {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(in.getContent(), result);
            out.setContent((Source)new BytesSource(buffer.toByteArray()));
        }
    }

    protected boolean shouldOutputResult(Transformer transformer) {
        return !this.disableOutput;
    }

    protected Source createXsltSource() throws IOException {
        if (this.xsltResource != null) {
            URL url = this.xsltResource.getURL();
            if (url == null) {
                return new StreamSource(this.xsltResource.getInputStream());
            }
            return new StreamSource(this.xsltResource.getInputStream(), url.toExternalForm());
        }
        return null;
    }

    public Templates getTemplates() throws IOException, TransformerConfigurationException {
        if (this.templates == null) {
            this.templates = this.createTemplates();
        }
        return this.templates;
    }

    protected Templates createTemplates() throws TransformerConfigurationException, IOException {
        Source source = this.getXsltSource();
        return this.getTransformerFactory().newTemplates(source);
    }

    protected Transformer createTransformer(MessageExchange exchange, NormalizedMessage in) throws TransformerConfigurationException, IOException {
        Source source = this.getXsltSource();
        if (source == null) {
            return this.getTransformerFactory().newTransformer();
        }
        return this.getTemplates().newTransformer();
    }

    protected void configureTransformer(Transformer transformer, MessageExchange exchange, NormalizedMessage in) {
        Object value;
        String name;
        Iterator iter = exchange.getPropertyNames().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = exchange.getProperty(name);
            transformer.setParameter(name, value);
        }
        iter = in.getPropertyNames().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            value = in.getProperty(name);
            transformer.setParameter(name, value);
        }
        transformer.setParameter("exchange", exchange);
        transformer.setParameter("in", in);
        transformer.setParameter("component", (Object)this);
    }
}

