/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.jencks.factory.WorkManagerFactoryBean;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class AbstractComponent
implements Component,
ComponentLifeCycle {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected ComponentContext context;
    protected ObjectName mbeanName;
    protected Map serviceDescriptions = new HashMap();
    protected Thread meListener;
    protected GeronimoWorkManager workManager;

    public ComponentContext getContext() {
        return this.context;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return null;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Querying service description for " + endpoint));
        }
        String key = this.getKey(endpoint.getServiceName(), endpoint.getEndpointName());
        Document doc = (Document)this.serviceDescriptions.get(key);
        if (this.logger.isDebugEnabled()) {
            if (doc != null) {
                this.logger.debug((Object)"Description found");
            } else {
                this.logger.debug((Object)"Description not found");
            }
        }
        return doc;
    }

    public void setServiceDescription(QName service, String endpoint, Document doc) {
        String key = this.getKey(service, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting service description for " + endpoint));
        }
        this.serviceDescriptions.put(key, doc);
    }

    private String getKey(QName service, String endpoint) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(service.getNamespaceURI());
        sb.append("}");
        sb.append(service.getLocalPart());
        sb.append(":");
        sb.append(endpoint);
        return sb.toString();
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        return null;
    }

    public final ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    public final void init(ComponentContext context) throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Initializing component");
            }
            this.context = context;
            this.doInit();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component initialized");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        Object mbean = this.getExtensionMBean();
        if (mbean != null) {
            this.mbeanName = this.createExtensionMBeanName();
            MBeanServer server = this.context.getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
            server.registerMBean(mbean, this.mbeanName);
        }
        WorkManagerFactoryBean wmfb = new WorkManagerFactoryBean();
        this.workManager = wmfb.getWorkManager();
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getMBeanNames().createCustomComponentMBeanName("extension");
    }

    public final void shutDown() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Shutting down component");
            }
            this.doShutDown();
            this.context = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component shut down");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling shutdown", (Throwable)e);
        }
    }

    protected void doShutDown() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
    }

    public final void start() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting component");
            }
            this.doStart();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component started");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        this.meListener = new Thread(new Runnable(){

            public void run() {
                try {
                    DeliveryChannel channel = AbstractComponent.this.context.getDeliveryChannel();
                    while (true) {
                        MessageExchange me;
                        if ((me = channel.accept()).isTransacted()) {
                            TransactionManager mgr = (TransactionManager)AbstractComponent.this.context.getTransactionManager();
                            Transaction tx = (Transaction)me.getProperty("javax.jbi.transaction.jta");
                            if (tx == mgr.getTransaction()) {
                                mgr.suspend();
                            }
                        }
                        AbstractComponent.this.workManager.scheduleWork(new Work(){

                            public void release() {
                            }

                            public void run() {
                                try {
                                    if (me.isTransacted()) {
                                        TransactionManager mgr = (TransactionManager)(this).AbstractComponent.this.context.getTransactionManager();
                                        Transaction tx = (Transaction)me.getProperty("javax.jbi.transaction.jta");
                                        mgr.resume(tx);
                                    }
                                    AbstractComponent.this.process(me);
                                }
                                catch (Exception e) {
                                    (this).AbstractComponent.this.logger.error((Object)"Error processing message", (Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    if (e instanceof MessagingException && e.getCause() instanceof InterruptedException) {
                        return;
                    }
                    AbstractComponent.this.logger.error((Object)"An exception occured in component polling thread", e);
                    return;
                }
            }
        });
        this.meListener.setDaemon(true);
        this.meListener.start();
    }

    protected void process(MessageExchange me) throws Exception {
    }

    public final void stop() throws JBIException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Stopping component");
            }
            this.doStop();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Component stopped");
            }
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling stop", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        if (this.meListener != null) {
            this.meListener.interrupt();
            this.meListener.join();
        }
        if (this.workManager != null) {
            this.workManager.doStop();
        }
    }
}

