/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.email;

import java.util.Date;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.TransformerException;
import org.servicemix.components.email.MailMarshalerSupport;

public class MimeMailMarshaler
extends MailMarshalerSupport {
    public void prepareMessage(MimeMessage mimeMessage, MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            Address[] replyTo;
            Date sentDate;
            String subject;
            String text;
            Address from;
            Address bcc;
            Address cc;
            Address to = this.getTo(exchange, normalizedMessage);
            if (to != null) {
                mimeMessage.setRecipient(Message.RecipientType.TO, to);
            }
            if ((cc = this.getCc(exchange, normalizedMessage)) != null) {
                mimeMessage.setRecipient(Message.RecipientType.CC, cc);
            }
            if ((bcc = this.getBcc(exchange, normalizedMessage)) != null) {
                mimeMessage.setRecipient(Message.RecipientType.BCC, bcc);
            }
            if ((from = this.getFrom(exchange, normalizedMessage)) != null) {
                mimeMessage.setFrom(from);
            }
            if ((text = this.getText(exchange, normalizedMessage)) != null) {
                mimeMessage.setText(text);
            }
            if ((subject = this.getSubject(exchange, normalizedMessage)) != null) {
                mimeMessage.setSubject(subject);
            }
            if ((sentDate = this.getSentDate(exchange, normalizedMessage)) != null) {
                mimeMessage.setSentDate(sentDate);
            }
            if ((replyTo = this.getReplyTo(exchange, normalizedMessage)) != null) {
                mimeMessage.setReplyTo(replyTo);
            }
        }
        catch (javax.jbi.messaging.MessagingException e) {
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (TransformerException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    protected Address getFrom(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asAddress(this.getFrom().evaluate(exchange, normalizedMessage));
    }

    protected Address getTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asAddress(this.getTo().evaluate(exchange, normalizedMessage));
    }

    protected Address getCc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asAddress(this.getCc().evaluate(exchange, normalizedMessage));
    }

    protected Address getBcc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asAddress(this.getBcc().evaluate(exchange, normalizedMessage));
    }

    protected Address[] getReplyTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asAddressArray(this.getReplyTo().evaluate(exchange, normalizedMessage));
    }
}

