/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.servicemix.components.jms.JmsInBinding;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.JmsTemplate102;

public class JmsReceiverComponent
extends JmsInBinding
implements InitializingBean,
DisposableBean {
    private JmsTemplate template;
    private String selector;
    private MessageConsumer consumer;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;

    public void afterPropertiesSet() throws Exception {
        if (this.template == null) {
            throw new IllegalArgumentException("Must have a template set");
        }
        this.connectionFactory = this.template.getConnectionFactory();
        if (this.template instanceof JmsTemplate102) {
            if (this.template.isPubSubDomain()) {
                TopicConnection tc = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
                this.connection = tc;
                this.session = tc.createTopicSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
            } else {
                QueueConnection qc = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
                this.connection = qc;
                this.session = qc.createQueueSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
            }
        } else {
            this.connection = this.connectionFactory.createConnection();
            this.session = this.connection.createSession(this.template.isSessionTransacted(), this.template.getSessionAcknowledgeMode());
        }
        Destination defaultDestination = this.template.getDefaultDestination();
        if (defaultDestination == null) {
            defaultDestination = this.template.getDestinationResolver().resolveDestinationName(this.session, this.template.getDefaultDestinationName(), this.template.isPubSubDomain());
        }
        this.consumer = this.template instanceof JmsTemplate102 ? (this.template.isPubSubDomain() ? ((TopicSession)this.session).createSubscriber((Topic)defaultDestination, this.selector, this.template.isPubSubNoLocal()) : ((QueueSession)this.session).createReceiver((Queue)defaultDestination, this.selector)) : this.session.createConsumer(defaultDestination, this.selector);
        this.consumer.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            if (this.connection != null) {
                this.connection.close();
            } else if (this.session != null) {
                this.session.close();
            } else if (this.consumer != null) {
                this.consumer.close();
            }
        }
        finally {
            this.connection = null;
            this.session = null;
            this.consumer = null;
        }
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }
}

