/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.drools;

import java.io.InputStream;
import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseLoader;
import org.servicemix.components.drools.FactMessagingException;
import org.servicemix.components.drools.JbiHelper;
import org.servicemix.components.util.OutBinding;
import org.springframework.core.io.Resource;

public class DroolsComponent
extends OutBinding {
    private RuleBase ruleBase;
    private Resource ruleBaseResource;
    private URL ruleBaseURL;

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public Resource getRuleBaseResource() {
        return this.ruleBaseResource;
    }

    public void setRuleBaseResource(Resource ruleBaseResource) {
        this.ruleBaseResource = ruleBaseResource;
    }

    public URL getRuleBaseURL() {
        return this.ruleBaseURL;
    }

    public void setRuleBaseURL(URL ruleBaseURL) {
        this.ruleBaseURL = ruleBaseURL;
    }

    public void forwardToService(MessageExchange exchange, NormalizedMessage in, QName name) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactoryForService(name);
        InOnly outExchange = factory.createInOnlyExchange();
        this.forwardToExchange(exchange, outExchange, in);
    }

    public void forwardToInterface(QName name, MessageExchange exchange, NormalizedMessage in) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory(name);
        InOnly outExchange = factory.createInOnlyExchange();
        this.forwardToExchange(exchange, outExchange, in);
    }

    protected void init() throws JBIException {
        block4: {
            super.init();
            try {
                if (this.ruleBase != null) break block4;
                if (this.ruleBaseResource != null) {
                    this.ruleBase = RuleBaseLoader.loadFromInputStream((InputStream)this.ruleBaseResource.getInputStream());
                    break block4;
                }
                if (this.ruleBaseURL != null) {
                    this.ruleBase = RuleBaseLoader.loadFromUrl((URL)this.ruleBaseURL);
                    break block4;
                }
                throw new IllegalArgumentException("You must specify a ruleBase, ruleBaseResource or ruleBaseURL property");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JBIException((Throwable)e);
            }
        }
    }

    protected void process(MessageExchange exchange, NormalizedMessage in) throws MessagingException {
        try {
            WorkingMemory memory = this.ruleBase.newWorkingMemory();
            this.populateWorkingMemory(memory, exchange, in);
            memory.fireAllRules();
            this.done(exchange);
        }
        catch (FactException e) {
            throw new FactMessagingException(e);
        }
    }

    protected void populateWorkingMemory(WorkingMemory memory, MessageExchange exchange, NormalizedMessage in) throws MessagingException, FactException {
        memory.setApplicationData("context", (Object)this.getContext());
        memory.setApplicationData("deliveryChannel", (Object)this.getDeliveryChannel());
        memory.setApplicationData("jbi", (Object)new JbiHelper(this, exchange, in));
        memory.assertObject((Object)in);
        memory.assertObject((Object)exchange);
    }
}

