/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.email;

import java.util.Date;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.email.MailMarshalerSupport;
import org.springframework.mail.SimpleMailMessage;

public class SimpleMailMarshaler
extends MailMarshalerSupport {
    private static final transient Log log = LogFactory.getLog((Class)SimpleMailMarshaler.class);

    public void prepareMessage(SimpleMailMessage mailMessage, MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            Date sentDate;
            String subject;
            String text;
            String replyTo;
            String from;
            Object bcc;
            Object cc;
            Object to = this.getTo(exchange, normalizedMessage);
            if (to != null) {
                if (to instanceof String) {
                    mailMessage.setTo((String)to);
                } else {
                    mailMessage.setTo((String[])to);
                }
            }
            if ((cc = this.getCc(exchange, normalizedMessage)) != null) {
                if (cc instanceof String) {
                    mailMessage.setCc((String)cc);
                } else {
                    mailMessage.setCc((String[])cc);
                }
            }
            if ((bcc = this.getBcc(exchange, normalizedMessage)) != null) {
                if (bcc instanceof String) {
                    mailMessage.setBcc((String)bcc);
                } else {
                    mailMessage.setBcc((String[])bcc);
                }
            }
            if ((from = this.getFrom(exchange, normalizedMessage)) != null) {
                mailMessage.setFrom(from);
            }
            if ((replyTo = this.getReplyTo(exchange, normalizedMessage)) != null) {
                mailMessage.setReplyTo(replyTo);
            }
            if ((text = this.getText(exchange, normalizedMessage)) != null) {
                mailMessage.setText(text);
            }
            if ((subject = this.getSubject(exchange, normalizedMessage)) != null) {
                mailMessage.setSubject(subject);
            }
            if ((sentDate = this.getSentDate(exchange, normalizedMessage)) != null) {
                mailMessage.setSentDate(sentDate);
            }
        }
        catch (javax.jbi.messaging.MessagingException e) {
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (TransformerException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    protected String getFrom(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asString(this.getFrom().evaluate(exchange, normalizedMessage));
    }

    protected String getReplyTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException {
        return this.asString(this.getReplyTo().evaluate(exchange, normalizedMessage));
    }

    protected Object getTo(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asStringOrStringArray(this.getTo().evaluate(exchange, normalizedMessage));
    }

    protected Object getCc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asStringOrStringArray(this.getCc().evaluate(exchange, normalizedMessage));
    }

    protected Object getBcc(MessageExchange exchange, NormalizedMessage normalizedMessage) throws javax.jbi.messaging.MessagingException, AddressException {
        return this.asStringOrStringArray(this.getBcc().evaluate(exchange, normalizedMessage));
    }
}

