/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.servicemix.MessageExchangeListener;
import org.servicemix.components.http.HttpClientMarshaler;
import org.servicemix.components.http.InvalidStatusResponseException;
import org.servicemix.components.util.TransformComponentSupport;

public class HttpInvoker
extends TransformComponentSupport
implements MessageExchangeListener {
    private HttpClientMarshaler marshaler = new HttpClientMarshaler();
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    private HostConfiguration hostConfiguration = new HostConfiguration();
    private String url;

    public void stop() throws JBIException {
        super.stop();
        this.connectionManager.shutdown();
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        PostMethod method = new PostMethod(this.url);
        try {
            int response;
            this.marshaler.fromNMS(method, in);
            if (this.url != null) {
                this.hostConfiguration.setHost(new URI(this.url, false));
            }
            if ((response = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)method)) != 200) {
                throw new InvalidStatusResponseException(response);
            }
            this.marshaler.toNMS(out, (HttpMethod)method);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new MessagingException("Error executing http request", (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

