/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.xml.transform.TransformerException;
import org.logicblaze.lingo.jms.JmsProducer;
import org.logicblaze.lingo.jms.JmsProducerPool;
import org.servicemix.components.jms.DestinationChooser;
import org.servicemix.components.jms.JmsMarshaler;
import org.servicemix.components.util.OutBinding;

public class JmsOutBinding
extends OutBinding {
    private JmsProducerPool producerPool;
    private DestinationChooser destinationChooser;
    private JmsMarshaler marshaler = new JmsMarshaler();

    public JmsProducerPool getProducerPool() {
        return this.producerPool;
    }

    public void setProducerPool(JmsProducerPool producerPool) {
        this.producerPool = producerPool;
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        this.destinationChooser = destinationChooser;
    }

    protected void process(MessageExchange messageExchange, NormalizedMessage inMessage) throws MessagingException {
        JmsProducer producer = this.producerPool.borrowProducer();
        try {
            Session session = producer.getSession();
            Message message = this.marshaler.createMessage(inMessage, session);
            Destination destination = this.destinationChooser.chooseDestination(messageExchange);
            producer.getMessageProducer().send(destination, message);
            this.done(messageExchange);
        }
        catch (JMSException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
        finally {
            this.producerPool.returnProducer(producer);
        }
    }
}

