/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.servicemix.components.jms.JmsInBinding;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.SessionCallback;

public class JmsReceiverComponent
extends JmsInBinding
implements InitializingBean,
DisposableBean {
    private JmsTemplate template;
    private String selector;
    private MessageConsumer consumer;

    public void afterPropertiesSet() throws Exception {
        if (this.template == null) {
            throw new IllegalArgumentException("Must have a template set");
        }
        this.template.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination defaultDestination = JmsReceiverComponent.this.template.getDefaultDestination();
                if (defaultDestination == null) {
                    defaultDestination = JmsReceiverComponent.this.template.getDestinationResolver().resolveDestinationName(session, JmsReceiverComponent.this.template.getDefaultDestinationName(), JmsReceiverComponent.this.template.isPubSubDomain());
                }
                JmsReceiverComponent.this.consumer = session.createConsumer(defaultDestination, JmsReceiverComponent.this.selector);
                return null;
            }
        }, true);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public void destroy() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }
}

