/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jms;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.xml.transform.TransformerException;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.jms.DestinationChooser;
import org.servicemix.components.jms.JmsMarshaler;
import org.servicemix.components.util.ComponentSupport;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;

public class JmsServiceComponent
extends ComponentSupport
implements MessageListener,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)JmsServiceComponent.class);
    private DestinationChooser destinationChooser;
    private JmsMarshaler marshaler = new JmsMarshaler();
    private JmsTemplate template;
    private String selector;
    private MessageConsumer consumer;

    public void afterPropertiesSet() throws Exception {
        if (this.template == null) {
            throw new IllegalArgumentException("Must have a template set");
        }
        this.template.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                Destination defaultDestination = JmsServiceComponent.this.template.getDefaultDestination();
                if (defaultDestination == null) {
                    defaultDestination = JmsServiceComponent.this.template.getDestinationResolver().resolveDestinationName(session, JmsServiceComponent.this.template.getDefaultDestinationName(), JmsServiceComponent.this.template.isPubSubDomain());
                }
                JmsServiceComponent.this.consumer = session.createConsumer(defaultDestination, JmsServiceComponent.this.selector);
                return null;
            }
        }, true);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public void destroy() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public DestinationChooser getDestinationChooser() {
        return this.destinationChooser;
    }

    public void setDestinationChooser(DestinationChooser destinationChooser) {
        this.destinationChooser = destinationChooser;
    }

    public JmsMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(JmsMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void onMessage(final Message jmsMessage) {
        block6: {
            try {
                final InOut messageExchange = this.getDeliveryChannel().createExchangeFactory().createInOutExchange();
                NormalizedMessage inMessage = messageExchange.createMessage();
                try {
                    this.marshaler.toNMS(inMessage, jmsMessage);
                    messageExchange.setInMessage(inMessage);
                    if (!this.getDeliveryChannel().sendSync((MessageExchange)messageExchange)) break block6;
                    Destination destination = this.getReplyToDestination(jmsMessage, messageExchange);
                    try {
                        this.template.send(destination, new MessageCreator(){

                            public Message createMessage(Session session) throws JMSException {
                                try {
                                    Message message = JmsServiceComponent.this.marshaler.createMessage(messageExchange.getOutMessage(), session);
                                    message.setJMSCorrelationID(jmsMessage.getJMSCorrelationID());
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)("Sending message to: " + JmsServiceComponent.this.template.getDefaultDestinationName() + " message: " + message));
                                    }
                                    return message;
                                }
                                catch (TransformerException e) {
                                    throw JMSExceptionHelper.newJMSException((String)("Failed to create JMS Message: " + e), (Exception)e);
                                }
                            }
                        });
                        this.done((MessageExchange)messageExchange);
                    }
                    catch (JmsException e) {
                        this.fail((MessageExchange)messageExchange, (Exception)((Object)e));
                    }
                }
                catch (JMSException e) {
                    log.error((Object)("Couldn't process " + jmsMessage), (Throwable)e);
                    messageExchange.setError((Exception)((Object)e));
                    messageExchange.setStatus(ExchangeStatus.ERROR);
                }
            }
            catch (MessagingException e) {
                log.error((Object)("Failed to process inbound JMS Message: " + jmsMessage), (Throwable)e);
            }
        }
    }

    protected Destination getReplyToDestination(Message jmsMessage, InOut messageExchange) throws JMSException {
        if (this.destinationChooser == null) {
            return jmsMessage.getJMSReplyTo();
        }
        return this.destinationChooser.chooseDestination((MessageExchange)messageExchange);
    }

    protected Destination chooseOutBoundDestination(MessageExchange exchange, Message inboundMessage) throws JMSException {
        Destination result = null;
        if (this.destinationChooser != null) {
            result = this.destinationChooser.chooseDestination(exchange);
        } else if (inboundMessage != null && inboundMessage.getJMSReplyTo() != null) {
            result = inboundMessage.getJMSReplyTo();
        }
        if (result == null) {
            log.error((Object)("Could not find an outbound destination for " + inboundMessage));
            throw new JMSException("No outbound JMS Destination can be found");
        }
        return result;
    }
}

