/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.net;

import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.servicemix.components.net.FTPClientPool;
import org.servicemix.components.util.DefaultFileMarshaler;
import org.servicemix.components.util.FileMarshaler;
import org.servicemix.components.util.OutBinding;

public class FTPSender
extends OutBinding {
    private static final Log log = LogFactory.getLog((Class)FTPSender.class);
    private FTPClientPool clientPool;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String uniqueFileName = "ServiceMix";
    private boolean overwrite = false;

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUniqueFileName() {
        return this.uniqueFileName;
    }

    public void setUniqueFileName(String uniqueFileName) {
        this.uniqueFileName = uniqueFileName;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    protected void init() throws JBIException {
        if (this.clientPool == null) {
            throw new IllegalArgumentException("You must initialise the clientPool property");
        }
        super.init();
    }

    protected void process(MessageExchange exchange, NormalizedMessage message) throws MessagingException {
        FTPClient client = null;
        OutputStream out = null;
        try {
            client = (FTPClient)this.getClientPool().borrowClient();
            String name = this.marshaler.getOutputName(exchange, message);
            if (name == null) {
                out = this.uniqueFileName != null ? client.storeUniqueFileStream(this.uniqueFileName) : client.storeUniqueFileStream();
            } else {
                out = client.storeFileStream(name);
                if (out == null) {
                    if (this.overwrite) {
                        client.deleteFile(name);
                    }
                    out = client.storeFileStream(name);
                }
            }
            if (out == null) {
                throw new MessagingException("No output stream available for output name: " + name + ". Maybe the file already exists?");
            }
            this.marshaler.writeMessage(exchange, message, out, name);
            this.done(exchange);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException((Throwable)e);
        }
        finally {
            this.returnClient((SocketClient)client);
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected void returnClient(SocketClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient(client);
            }
            catch (Exception e) {
                log.error((Object)("Failed to return client to pool: " + e), (Throwable)e);
            }
        }
    }
}

