/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.quartz;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.servicemix.components.quartz.DefaultQuartzMarshaler;
import org.servicemix.components.quartz.QuartzMarshaler;
import org.servicemix.components.quartz.ServiceMixJob;
import org.servicemix.components.util.ComponentSupport;

public class QuartzComponent
extends ComponentSupport {
    private static final transient Log log = LogFactory.getLog((Class)QuartzComponent.class);
    public static final String COMPONENT_KEY = "org.servicemix.component";
    private SchedulerFactory factory;
    private Scheduler scheduler;
    private Map triggers;
    private QuartzMarshaler marshaler = new DefaultQuartzMarshaler();

    public void start() throws JBIException {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void stop() throws JBIException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void addTrigger(Trigger trigger, JobDetail detail) throws JBIException {
        try {
            if (trigger.getName() == null) {
                trigger.setName(detail.getName());
            }
            if (trigger.getGroup() == null) {
                trigger.setGroup(detail.getGroup());
            }
            if (trigger.getStartTime() == null) {
                trigger.setStartTime(new Date());
            }
            detail.getJobDataMap().put((Object)COMPONENT_KEY, (Object)this);
            Class jobClass = detail.getJobClass();
            if (jobClass == null) {
                detail.setJobClass(ServiceMixJob.class);
            }
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException e) {
            throw new JBIException("Failed to add trigger: " + trigger + " with detail: " + detail + ". Reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void onJobExecute(JobExecutionContext context) throws JobExecutionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Firing Quartz Job with context: " + context));
        }
        try {
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage message = exchange.createMessage();
            this.getMarshaler().populateNormalizedMessage(message, context);
            exchange.setInMessage(message);
            this.send((MessageExchange)exchange);
        }
        catch (MessagingException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }

    public SchedulerFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SchedulerFactory factory) {
        this.factory = factory;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Map triggers) {
        this.triggers = triggers;
    }

    public QuartzMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(QuartzMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void init() throws JBIException {
        super.init();
        try {
            if (this.scheduler == null) {
                if (this.factory == null) {
                    this.factory = new StdSchedulerFactory();
                }
                this.scheduler = this.factory.getScheduler();
            }
        }
        catch (SchedulerException e) {
            throw new JBIException((Throwable)e);
        }
        if (this.triggers != null) {
            Iterator iter = this.triggers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null) {
                    throw new IllegalArgumentException("Key of the map cannot be null");
                }
                if (value == null) {
                    throw new IllegalArgumentException("Key of the map cannot be null");
                }
                if (!(key instanceof Trigger)) {
                    throw new IllegalArgumentException("Key of the map must be a Trigger but was: " + key.getClass().getName());
                }
                if (!(value instanceof JobDetail)) {
                    throw new IllegalArgumentException("Key of the map must be a JobDetail but was: " + value.getClass().getName());
                }
                this.addTrigger((Trigger)key, (JobDetail)value);
            }
        }
    }
}

