/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.wsif;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.servicemix.components.util.OutBinding;
import org.servicemix.components.wsif.WSIFMarshaler;
import org.servicemix.components.wsif.WSIFOperationInfo;
import org.servicemix.components.wsif.WSIFOperationMap;

public class WSIFOutBinding
extends OutBinding {
    private WSIFMarshaler marshaler = new WSIFMarshaler();
    private WSIFOperationMap operationMap;

    public WSIFMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(WSIFMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public WSIFOperationMap getOperationMap() {
        return this.operationMap;
    }

    public void setOperationMap(WSIFOperationMap operationMap) {
        this.operationMap = operationMap;
    }

    protected void process(MessageExchange exchange, NormalizedMessage normalizedMessage) throws MessagingException {
        try {
            WSIFOperationInfo operationInfo = this.operationMap.getOperationForExchange(exchange);
            WSIFOperation operation = operationInfo.getWsifOperation();
            WSIFMessage message = operation.createInputMessage();
            this.marshaler.fromNMS(operationInfo, message, normalizedMessage, this.getBody(normalizedMessage));
            operation.executeInputOnlyOperation(message);
            this.done(exchange);
        }
        catch (WSIFException e) {
            exchange.setError((Exception)((Object)e));
            exchange.setStatus(ExchangeStatus.ERROR);
        }
    }
}

