/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.far.filecontents;

import java.nio.charset.Charset;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import software.xdev.far.BaseMojo;
import software.xdev.far.ExecData;
import software.xdev.far.filecontents.FileContentsExecData;
import software.xdev.far.filecontents.FileContentsProcessor;

@Mojo(name="file-contents", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class FileContentsMojo
extends BaseMojo<FileContentsExecData> {
    @Parameter(property="encoding")
    protected String encoding;
    @Parameter(property="replaceLineBased", defaultValue="true")
    protected boolean replaceLineBased = true;

    public FileContentsMojo() {
        super(FileContentsProcessor::new);
    }

    @Override
    protected FileContentsExecData enrichData(ExecData data) {
        return new FileContentsExecData(data, Optional.ofNullable(this.encoding).map(e -> {
            try {
                return Charset.forName(e);
            }
            catch (Exception ex) {
                return null;
            }
        }).orElseGet(Charset::defaultCharset), this.replaceLineBased);
    }

    @Override
    protected Pattern compileFindRegex() {
        return !this.replaceLineBased ? Pattern.compile(this.findRegex, 8) : super.compileFindRegex();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplaceLineBased(boolean replaceLineBased) {
        this.replaceLineBased = replaceLineBased;
    }
}

