/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.far.find_and_replace;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import software.xdev.far.BaseProcessor;
import software.xdev.far.find_and_replace.FindAndReplaceExecData;

@Deprecated
public class FindAndReplaceProcessor
extends BaseProcessor<FindAndReplaceExecData> {
    public FindAndReplaceProcessor(FindAndReplaceExecData execData) {
        super(execData, false);
        this.processDirectoryNames = execData.isProcessDirectoryNames();
        this.processFilenames = execData.isProcessFilenames();
        this.processFileContents = execData.isProcessFileContents();
    }

    @Override
    protected File handleDirectory(File file) {
        return this.renameFileDefault(file);
    }

    @Override
    protected File handleFile(File file) {
        return this.renameFileDefault(file);
    }

    @Override
    protected void handleFileContents(File file) {
        try {
            Path tempFile = this.createTempFile(file);
            try (FileInputStream fis = new FileInputStream(file);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, ((FindAndReplaceExecData)this.execData).getCharset());
                 BufferedReader fileReader = new BufferedReader(isr);
                 FileOutputStream fos = new FileOutputStream(tempFile.toFile());
                 OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, ((FindAndReplaceExecData)this.execData).getCharset());
                 BufferedWriter fileWriter = new BufferedWriter(osr);){
                boolean alreadyReplaced = false;
                String line = fileReader.readLine();
                while (line != null) {
                    Matcher matcher = ((FindAndReplaceExecData)this.execData).getFindRegex().matcher(line);
                    String lineToWrite = line;
                    if (matcher.find()) {
                        if (((FindAndReplaceExecData)this.execData).isReplaceAll()) {
                            lineToWrite = matcher.replaceAll(((FindAndReplaceExecData)this.execData).getReplaceValue());
                        } else if (!alreadyReplaced) {
                            lineToWrite = matcher.replaceFirst(((FindAndReplaceExecData)this.execData).getReplaceValue());
                            alreadyReplaced = true;
                        }
                    }
                    fileWriter.write(lineToWrite + System.lineSeparator());
                    line = fileReader.readLine();
                }
            }
            Files.delete(file.toPath());
            if (!tempFile.toFile().renameTo(file)) {
                throw new IOException("Failed to rename temp file at: " + tempFile + " to " + file.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Path createTempFile(File original) throws IOException {
        return Files.createTempFile(original.getParentFile().toPath(), "tmp", "tmp", new FileAttribute[0]);
    }
}

