/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.filter;

import com.subshell.persistence.exception.ErrorInRunnableException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.filter.TransactionFilterRunnable;
import com.subshell.persistence.runner.SimpleTransactionContextRunner;
import com.subshell.persistence.runner.TransactionContextRunner;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionFilter
implements Filter {
    private static final Log log = LogFactory.getLog(TransactionFilter.class);
    private TransactionContextRunner transactionContextRunner;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.debug((Object)"getting transaction context runner");
        this.transactionContextRunner = this.getRunner();
        if (this.transactionContextRunner == null) {
            log.error((Object)"no transaction context runner returned");
            throw new ServletException("no transaction context runner returned");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException {
        log.debug((Object)"creating runnable");
        TransactionFilterRunnable runnable = new TransactionFilterRunnable(filterChain, request, response);
        log.debug((Object)"running runnable using transaction context runner");
        try {
            this.transactionContextRunner.run(runnable);
        }
        catch (ErrorInRunnableException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (PersistenceException e) {
            log.error((Object)"", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected TransactionContextRunner getRunner() {
        return new SimpleTransactionContextRunner();
    }
}

