/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.mapper;

import com.subshell.persistence.exception.InitializationException;
import com.subshell.persistence.exception.PersistenceMapperNotFoundException;
import com.subshell.persistence.mapper.PersistenceMapper;
import com.subshell.persistence.mapper.PersistenceMapperConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyPersistenceMapperConfiguration
implements PersistenceMapperConfiguration {
    private static final Log log = LogFactory.getLog(PropertyPersistenceMapperConfiguration.class);
    private Map<Class<?>, Class<?>> mapperClasses = new HashMap();

    public PropertyPersistenceMapperConfiguration(Properties props) {
        try {
            this.loadPersistenceMappers(props);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(e);
        }
    }

    public PropertyPersistenceMapperConfiguration(File file) throws IOException {
        try {
            this.loadPersistenceMappers(file);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersistenceMappers(File file) throws IOException, ClassNotFoundException {
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            props.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)"", (Throwable)e);
                }
            }
        }
        this.loadPersistenceMappers(props);
    }

    private void loadPersistenceMappers(Properties props) throws ClassNotFoundException {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String objectClassName = (String)e.nextElement();
            String mapperClassName = props.getProperty(objectClassName);
            this.addPersistenceMapper(objectClassName, mapperClassName);
        }
    }

    private void addPersistenceMapper(String objectClassName, String mapperClassName) throws ClassNotFoundException {
        Class<?> objectClass = Class.forName(objectClassName);
        Class<?> mapperClass = Class.forName(mapperClassName);
        Class<?> currentMapperClass = this.mapperClasses.get(objectClass);
        if (currentMapperClass != null) {
            throw new IllegalArgumentException("can't register persistence mapper " + mapperClassName + " for objects class " + objectClassName + ": " + "persistence mapper " + currentMapperClass.getClass().getName() + " already registered for this objects class");
        }
        if (!PersistenceMapper.class.isAssignableFrom(mapperClass)) {
            throw new IllegalArgumentException("persistence mapper class " + mapperClassName + " for objects class " + objectClassName + " " + "is not a PersistenceMapper");
        }
        if (PersistenceMapper.class.equals(mapperClass)) {
            throw new IllegalArgumentException("persistence mapper class " + mapperClassName + " for objects class " + objectClassName + " " + "must not be " + PersistenceMapper.class.getName() + " itself");
        }
        if (mapperClass.isInterface()) {
            throw new IllegalArgumentException("persistence mapper class " + mapperClassName + " for objects class " + objectClassName + " " + "must not be an interface");
        }
        if (Modifier.isAbstract(mapperClass.getModifiers())) {
            throw new IllegalArgumentException("persistence mapper class " + mapperClassName + " for objects class " + objectClassName + " " + "must not be abstract");
        }
        if (!Modifier.isPublic(mapperClass.getModifiers())) {
            throw new IllegalArgumentException("persistence mapper class " + mapperClassName + " for objects class " + objectClassName + " " + "must be public");
        }
        this.mapperClasses.put(objectClass, mapperClass);
    }

    @Override
    public <T> Class<PersistenceMapper<T>> getMapperForClass(Class<T> clazz) {
        Class<PersistenceMapper<T>> mapper = this.mapperClasses.get(clazz);
        if (mapper == null) {
            throw new PersistenceMapperNotFoundException("no persistence mapper found for objects class " + clazz.getName());
        }
        return mapper;
    }
}

