/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.runner;

import com.subshell.persistence.exception.ErrorInRunnableException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.exception.TransactionContextNotSetException;
import com.subshell.persistence.runner.SelfContainedTransactionContextRunnerThread;
import com.subshell.persistence.runner.SimpleTransactionContextRunner;
import com.subshell.persistence.runner.TransactionContextRunner;
import com.subshell.persistence.transaction.TransactionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfContainedTransactionContextRunner
implements TransactionContextRunner {
    private static final Log log = LogFactory.getLog(SelfContainedTransactionContextRunner.class);

    public final void run(Runnable runnable) throws ErrorInRunnableException, PersistenceException {
        if (runnable == null) {
            throw new IllegalArgumentException("no runnable specified");
        }
        TransactionContextRunner innerRunner = this.createTransactionContextRunner();
        if (innerRunner == null) {
            throw new PersistenceException("no transaction context runner returned");
        }
        if (this.isTransactionContextAssociatedWithCurrentThread()) {
            this.runInChildThread(runnable, innerRunner);
        } else {
            this.runInCurrentThread(runnable, innerRunner);
        }
    }

    private boolean isTransactionContextAssociatedWithCurrentThread() {
        boolean result;
        try {
            TransactionContext.getCurrentContext();
            result = true;
        }
        catch (TransactionContextNotSetException e) {
            result = false;
        }
        return result;
    }

    private void runInChildThread(Runnable runnable, TransactionContextRunner innerRunner) throws ErrorInRunnableException, PersistenceException {
        SelfContainedTransactionContextRunnerThread thread = new SelfContainedTransactionContextRunnerThread(runnable, innerRunner);
        thread.setPriority(Thread.currentThread().getPriority());
        thread.start();
        while (true) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.warn((Object)"got interrupted while waiting for transaction context runner, ignoring");
                continue;
            }
            break;
        }
        ErrorInRunnableException errorInRunnableException = thread.getErrorInRunnableException();
        if (errorInRunnableException != null) {
            throw errorInRunnableException;
        }
        PersistenceException persistenceException = thread.getPersistenceException();
        if (persistenceException != null) {
            throw persistenceException;
        }
    }

    private void runInCurrentThread(Runnable runnable, TransactionContextRunner runner) throws ErrorInRunnableException, PersistenceException {
        runner.run(runnable);
    }

    protected TransactionContextRunner createTransactionContextRunner() {
        return new SimpleTransactionContextRunner();
    }
}

