/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.transaction;

import com.subshell.persistence.exception.TransactionContextAlreadySetException;
import com.subshell.persistence.exception.TransactionContextNotSetException;
import com.subshell.persistence.mapper.PersistenceMapper;
import com.subshell.persistence.transaction.Transaction;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionContext {
    private static final ThreadLocal<TransactionContext> currentContext = new ThreadLocal();
    private Transaction transaction;
    private Map<Class<?>, PersistenceMapper<?>> persistenceMappers = new HashMap();

    public TransactionContext(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("no transaction specified");
        }
        this.transaction = transaction;
    }

    public static TransactionContext getCurrentContext() {
        TransactionContext context = currentContext.get();
        if (context == null) {
            throw new TransactionContextNotSetException("no transaction context associated with current thread");
        }
        return context;
    }

    public static void setCurrentContext(TransactionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("no transaction context specified");
        }
        if (currentContext.get() != null) {
            throw new TransactionContextAlreadySetException("transaction context already associated with current thread");
        }
        currentContext.set(context);
    }

    public static void clearCurrentContext() {
        if (currentContext.get() == null) {
            throw new TransactionContextNotSetException("no transaction context associated with current thread");
        }
        currentContext.set(null);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public <T> PersistenceMapper<T> getPersistenceMapper(Class<T> clazz) {
        PersistenceMapper<?> mapper = this.persistenceMappers.get(clazz);
        return mapper;
    }

    public <T> void addPersistenceMapper(Class<T> clazz, PersistenceMapper<T> mapper) {
        this.persistenceMappers.put(clazz, mapper);
    }
}

