/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.database;

import com.subshell.persistence.database.Database;
import com.subshell.persistence.exception.InitializationException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class DatabaseFactory {
    private static final Logger log = Logger.getLogger((Class)DatabaseFactory.class);
    private static Database database = null;

    private DatabaseFactory() {
    }

    public static synchronized Database getDatabase() {
        if (database == null) {
            InputStream in = null;
            try {
                in = new BufferedInputStream(DatabaseFactory.class.getClassLoader().getResourceAsStream("databaseFactory.properties"));
                Properties props = new Properties();
                props.load(in);
                String className = props.getProperty("databaseClass");
                Class<?> databaseClass = Class.forName(className);
                if (!Database.class.isAssignableFrom(databaseClass)) {
                    throw new IllegalArgumentException("specified class is not a Database subclass");
                }
                database = (Database)databaseClass.newInstance();
            }
            catch (IOException e) {
                throw new InitializationException("couldn't initialize DatabaseFactory", e);
            }
            catch (ClassNotFoundException e) {
                throw new InitializationException("couldn't initialize DatabaseFactory", e);
            }
            catch (InstantiationException e) {
                throw new InitializationException("couldn't initialize DatabaseFactory", e);
            }
            catch (IllegalAccessException e) {
                throw new InitializationException("couldn't initialize DatabaseFactory", e);
            }
            catch (IllegalArgumentException e) {
                throw new InitializationException("couldn't initialize DatabaseFactory", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"", (Throwable)e);
                    }
                }
            }
        }
        return database;
    }
}

