/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.hibernate;

import com.subshell.persistence.database.Database;
import com.subshell.persistence.exception.DatabaseClosedException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.hibernate.HibernateTransaction;
import com.subshell.persistence.transaction.Transaction;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

public class HibernateDatabase
implements Database {
    private SessionFactory sessionFactory = null;
    private boolean closed = false;

    synchronized SessionFactory getSessionFactory() throws HibernateException, PersistenceException {
        if (this.sessionFactory == null) {
            this.sessionFactory = new Configuration().configure().buildSessionFactory();
            if (this.sessionFactory == null) {
                throw new PersistenceException("couldn't initialize HibernateDatabase (unknown reason)");
            }
        }
        return this.sessionFactory;
    }

    public synchronized void close() throws PersistenceException {
        this.checkClosed();
        try {
            this.getSessionFactory().close();
            this.closed = true;
        }
        catch (HibernateException e) {
            throw new PersistenceException(e);
        }
    }

    public synchronized Transaction openTransaction() {
        this.checkClosed();
        return new HibernateTransaction(this);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new DatabaseClosedException("this Database has been closed");
        }
    }
}

