/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.hibernate;

import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.exception.TransactionCommittedException;
import com.subshell.persistence.hibernate.HibernateDatabase;
import com.subshell.persistence.transaction.Transaction;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.Session;
import net.sf.hibernate.TransientObjectException;
import org.apache.log4j.Logger;

public class HibernateTransaction
implements Transaction {
    private static final Logger log = Logger.getLogger((Class)HibernateTransaction.class);
    private HibernateDatabase database;
    private Session session = null;
    private boolean committed = false;

    HibernateTransaction(HibernateDatabase database) {
        this.database = database;
    }

    public Object load(Class clazz, Serializable id) throws PersistenceException {
        if (clazz == null) {
            throw new IllegalArgumentException("no class specified");
        }
        if (id == null) {
            throw new IllegalArgumentException("no ID specified");
        }
        try {
            return this.getSession().load(clazz, id);
        }
        catch (ObjectNotFoundException e) {
            log.error((Object)"", (Throwable)e);
            throw new com.subshell.persistence.exception.ObjectNotFoundException(e);
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
    }

    public Serializable create(Object o) throws PersistenceException {
        if (o == null) {
            throw new IllegalArgumentException("no object specified");
        }
        try {
            return this.getSession().save(o);
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
    }

    public void delete(Object o) throws PersistenceException {
        if (o == null) {
            throw new IllegalArgumentException("no object specified");
        }
        try {
            this.getSession().delete(o);
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
    }

    public boolean isPersistent(Object o) throws PersistenceException {
        if (o == null) {
            throw new IllegalArgumentException("no object specified");
        }
        boolean result = false;
        try {
            Serializable id = this.getSession().getIdentifier(o);
            result = id != null;
        }
        catch (TransientObjectException e) {
        }
        catch (HibernateException e) {
            throw new PersistenceException(e);
        }
        return result;
    }

    public void commit() throws PersistenceException {
        try {
            Session s = this.getSession();
            log.debug((Object)"flushing session");
            s.flush();
            log.debug((Object)"committing transaction");
            s.connection().commit();
            log.debug((Object)"closing session");
            s.close();
            this.committed = true;
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
    }

    public void rollback() throws PersistenceException {
        Session s = null;
        try {
            s = this.getSession();
            log.debug((Object)"rolling back transaction");
            s.connection().rollback();
            this.committed = true;
        }
        catch (HibernateException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException(e);
        }
        finally {
            if (s != null) {
                try {
                    log.debug((Object)"closing session");
                    s.close();
                }
                catch (HibernateException e) {
                    log.error((Object)"", (Throwable)e);
                    throw new PersistenceException(e);
                }
            }
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public Session getSession() throws HibernateException, PersistenceException {
        this.checkCommitted();
        if (this.session == null) {
            this.session = this.database.getSessionFactory().openSession();
            if (this.session == null) {
                throw new PersistenceException("couldn't open Hibernate session (unknown reason)");
            }
            this.setupConnection(this.session.connection());
        }
        return this.session;
    }

    void setupConnection(Connection conn) throws PersistenceException {
        log.debug((Object)"checking if database supports transactions");
        try {
            if (!conn.getMetaData().supportsTransactions()) {
                throw new PersistenceException("database does not support transactions");
            }
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException("couldn't determine whether database supports transactions", e);
        }
        log.debug((Object)"disabling auto commit");
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            throw new PersistenceException("couldn't disable auto commit", e);
        }
    }

    private void checkCommitted() {
        if (this.committed) {
            throw new TransactionCommittedException("transaction has been committed/rolled back");
        }
    }
}

