/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.runner;

import com.subshell.persistence.database.DatabaseFactory;
import com.subshell.persistence.exception.ErrorInRunnableException;
import com.subshell.persistence.exception.PersistenceException;
import com.subshell.persistence.runner.TransactionContextRunner;
import com.subshell.persistence.transaction.Transaction;
import com.subshell.persistence.transaction.TransactionContext;
import org.apache.log4j.Logger;

public class SimpleTransactionContextRunner
implements TransactionContextRunner {
    private static final Logger log = Logger.getLogger((Class)SimpleTransactionContextRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(Runnable runnable) throws ErrorInRunnableException, PersistenceException {
        if (runnable == null) {
            throw new IllegalArgumentException("no runnable specified");
        }
        Transaction tx = null;
        boolean transactionContextSet = false;
        try {
            log.debug((Object)"opening transaction");
            tx = this.openTransaction();
            if (tx == null) {
                log.error((Object)"no transaction returned");
                throw new PersistenceException("no transaction returned");
            }
            log.debug((Object)"setting up transaction context");
            TransactionContext context = new TransactionContext(tx);
            TransactionContext.setCurrentContext(context);
            transactionContextSet = true;
            log.debug((Object)"executing runnable");
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                throw new ErrorInRunnableException("error while executing runnable", e);
            }
            log.debug((Object)"committing transaction");
            tx.commit();
        }
        finally {
            if (transactionContextSet) {
                log.debug((Object)"destroying transaction context");
                TransactionContext.clearCurrentContext();
            }
            if (tx != null && !tx.isCommitted()) {
                log.debug((Object)"rolling back transaction");
                tx.rollback();
            }
        }
    }

    protected Transaction openTransaction() throws PersistenceException {
        return DatabaseFactory.getDatabase().openTransaction();
    }
}

