/*
 * Decompiled with CFR 0.152.
 */
package com.subshell.persistence.transaction;

import com.subshell.persistence.exception.TransactionContextAlreadySetException;
import com.subshell.persistence.exception.TransactionContextNotSetException;
import com.subshell.persistence.transaction.Transaction;

public class TransactionContext {
    private static final ThreadLocal currentContext = new ThreadLocal();
    private Transaction transaction;

    public TransactionContext(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("no transaction specified");
        }
        this.transaction = transaction;
    }

    public static TransactionContext getCurrentContext() {
        TransactionContext context = (TransactionContext)currentContext.get();
        if (context == null) {
            throw new TransactionContextNotSetException("no transaction context associated with current thread");
        }
        return context;
    }

    public static void setCurrentContext(TransactionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("no transaction context specified");
        }
        if (currentContext.get() != null) {
            throw new TransactionContextAlreadySetException("transaction context already associated with current thread");
        }
        currentContext.set(context);
    }

    public static void clearCurrentContext() {
        if (currentContext.get() == null) {
            throw new TransactionContextNotSetException("no transaction context associated with current thread");
        }
        currentContext.set(null);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

