/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.structure.paginate;

import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.section.feature.FeatureScenarioDetails;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.util.TextUtil;

public class FeaturePaginator {
    private FeatureData data;
    private PaginatedSection section;
    private int maxFeaturesPerPage;

    public void paginate() {
        float currentHeight = FeatureScenarioDetails.headerRowHeight();
        int fromIndex = 0;
        int toIndex = 0;
        TextUtil textUtil = FeatureScenarioDetails.featureNameTextUtil();
        for (int i = 0; i < this.data.getFeatures().size(); ++i) {
            textUtil.setText(FeatureScenarioDetails.featureNameTextOptimizer.optimizeTextLines(this.data.getFeatures().get(i).getName()));
            if ((currentHeight += textUtil.tableRowHeight()) > 290.0f || toIndex - fromIndex + 1 > this.maxFeaturesPerPage) {
                this.section.generateDisplay(fromIndex, toIndex);
                fromIndex = toIndex;
                currentHeight = FeatureScenarioDetails.headerRowHeight();
                --i;
                continue;
            }
            ++toIndex;
        }
        this.section.generateDisplay(fromIndex, toIndex);
    }

    FeaturePaginator(FeatureData data, PaginatedSection section, int maxFeaturesPerPage) {
        this.data = data;
        this.section = section;
        this.maxFeaturesPerPage = maxFeaturesPerPage;
    }

    public static FeaturePaginatorBuilder builder() {
        return new FeaturePaginatorBuilder();
    }

    public static class FeaturePaginatorBuilder {
        private FeatureData data;
        private PaginatedSection section;
        private int maxFeaturesPerPage;

        FeaturePaginatorBuilder() {
        }

        public FeaturePaginatorBuilder data(FeatureData data) {
            this.data = data;
            return this;
        }

        public FeaturePaginatorBuilder section(PaginatedSection section) {
            this.section = section;
            return this;
        }

        public FeaturePaginatorBuilder maxFeaturesPerPage(int maxFeaturesPerPage) {
            this.maxFeaturesPerPage = maxFeaturesPerPage;
            return this;
        }

        public FeaturePaginator build() {
            return new FeaturePaginator(this.data, this.section, this.maxFeaturesPerPage);
        }

        public String toString() {
            return "FeaturePaginator.FeaturePaginatorBuilder(data=" + this.data + ", section=" + this.section + ", maxFeaturesPerPage=" + this.maxFeaturesPerPage + ")";
        }
    }
}

