/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config.verify;

import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.pdf.config.verify.VerifyConfiguration;

public class VerifyDisplayConfiguration
extends VerifyConfiguration {
    private static final Logger logger = Logger.getLogger(VerifyDisplayConfiguration.class.getName());

    @Override
    public void verify() {
        if (this.reportConfig.isDisplayDetailed()) {
            if (this.reportConfig.isDisplayExpanded() && this.reportConfig.isDisplayAttached()) {
                this.reportConfig.setDisplayExpanded(false);
                logger.log(Level.WARNING, "Media display as attachment (displayAttached) and expanded (displayExpanded) both set to true. Only one can be selected. Defaulting to attachment display.");
            }
        } else if (this.reportConfig.isDisplayExpanded() || this.reportConfig.isDisplayAttached()) {
            logger.log(Level.INFO, "Detailed section display is not set to true, no attachment or expanded media display will be available.");
            this.reportConfig.setDisplayExpanded(false);
            this.reportConfig.setDisplayAttached(false);
        }
    }

    protected VerifyDisplayConfiguration(VerifyDisplayConfigurationBuilder<?, ?> b) {
        super(b);
    }

    public static VerifyDisplayConfigurationBuilder<?, ?> builder() {
        return new VerifyDisplayConfigurationBuilderImpl();
    }

    private static final class VerifyDisplayConfigurationBuilderImpl
    extends VerifyDisplayConfigurationBuilder<VerifyDisplayConfiguration, VerifyDisplayConfigurationBuilderImpl> {
        private VerifyDisplayConfigurationBuilderImpl() {
        }

        @Override
        protected VerifyDisplayConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public VerifyDisplayConfiguration build() {
            return new VerifyDisplayConfiguration(this);
        }
    }

    public static abstract class VerifyDisplayConfigurationBuilder<C extends VerifyDisplayConfiguration, B extends VerifyDisplayConfigurationBuilder<C, B>>
    extends VerifyConfiguration.VerifyConfigurationBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VerifyDisplayConfiguration.VerifyDisplayConfigurationBuilder(super=" + super.toString() + ")";
        }
    }
}

