/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config;

import java.awt.Color;
import tech.grasshopper.pdf.config.DashboardConfig;
import tech.grasshopper.pdf.config.DetailedConfig;
import tech.grasshopper.pdf.config.ParameterConfig;
import tech.grasshopper.pdf.config.verify.VerifyDisplayConfiguration;
import tech.grasshopper.pdf.config.verify.VerifyHookConfiguration;

public class ReportConfig {
    private String passColor;
    private String failColor;
    private String skipColor;
    private boolean displayTag = true;
    private boolean displayDevice = true;
    private boolean displayAuthor = true;
    private boolean displayFeature = true;
    private boolean displayScenario = true;
    private boolean displayDetailed = true;
    private boolean displayAttached = true;
    private boolean displayExpanded = false;
    private DashboardConfig dashboardConfig = new DashboardConfig();
    private FeatureConfig featureConfig = new FeatureConfig();
    private ScenarioConfig scenarioConfig = new ScenarioConfig();
    private NoPassScenarioConfig noPassScenarioConfig = new NoPassScenarioConfig();
    private SummaryConfig summaryConfig = new SummaryConfig();
    private TagConfig tagConfig = new TagConfig();
    private DeviceConfig deviceConfig = new DeviceConfig();
    private AuthorConfig authorConfig = new AuthorConfig();
    private DetailedConfig.DetailedFeatureConfig detailedFeatureConfig = new DetailedConfig.DetailedFeatureConfig();
    private DetailedConfig.DetailedScenarioConfig detailedScenarioConfig = new DetailedConfig.DetailedScenarioConfig();
    private DetailedConfig.DetailedStepHookConfig detailedStepHookConfig = new DetailedConfig.DetailedStepHookConfig();

    public void verifyAndUpdate() {
        ((VerifyDisplayConfiguration)((VerifyDisplayConfiguration.VerifyDisplayConfigurationBuilder)VerifyDisplayConfiguration.builder().reportConfig(this)).build()).verify();
        ((VerifyHookConfiguration)((VerifyHookConfiguration.VerifyHookConfigurationBuilder)VerifyHookConfiguration.builder().reportConfig(this)).build()).verify();
    }

    public Color passedColor() {
        return ReportConfig.createColor(this.passColor, Color.GREEN);
    }

    public Color failedColor() {
        return ReportConfig.createColor(this.failColor, Color.RED);
    }

    public Color skippedColor() {
        return ReportConfig.createColor(this.skipColor, Color.ORANGE);
    }

    static Color createColor(String hexCode, Color defaultColor) {
        try {
            return Color.decode("#" + hexCode);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    static int createCount(String itemCount, int defaultCount) {
        int count = 0;
        try {
            count = Integer.parseInt(itemCount);
            if (count > defaultCount) {
                return defaultCount;
            }
        }
        catch (NumberFormatException e) {
            return defaultCount;
        }
        return count;
    }

    public void mergeParameterConfig(ParameterConfig parameterConfig) {
        parameterConfig.mergeConfigurations(this);
    }

    public String getPassColor() {
        return this.passColor;
    }

    public String getFailColor() {
        return this.failColor;
    }

    public String getSkipColor() {
        return this.skipColor;
    }

    public boolean isDisplayTag() {
        return this.displayTag;
    }

    public boolean isDisplayDevice() {
        return this.displayDevice;
    }

    public boolean isDisplayAuthor() {
        return this.displayAuthor;
    }

    public boolean isDisplayFeature() {
        return this.displayFeature;
    }

    public boolean isDisplayScenario() {
        return this.displayScenario;
    }

    public boolean isDisplayDetailed() {
        return this.displayDetailed;
    }

    public boolean isDisplayAttached() {
        return this.displayAttached;
    }

    public boolean isDisplayExpanded() {
        return this.displayExpanded;
    }

    public DashboardConfig getDashboardConfig() {
        return this.dashboardConfig;
    }

    public FeatureConfig getFeatureConfig() {
        return this.featureConfig;
    }

    public ScenarioConfig getScenarioConfig() {
        return this.scenarioConfig;
    }

    public NoPassScenarioConfig getNoPassScenarioConfig() {
        return this.noPassScenarioConfig;
    }

    public SummaryConfig getSummaryConfig() {
        return this.summaryConfig;
    }

    public TagConfig getTagConfig() {
        return this.tagConfig;
    }

    public DeviceConfig getDeviceConfig() {
        return this.deviceConfig;
    }

    public AuthorConfig getAuthorConfig() {
        return this.authorConfig;
    }

    public DetailedConfig.DetailedFeatureConfig getDetailedFeatureConfig() {
        return this.detailedFeatureConfig;
    }

    public DetailedConfig.DetailedScenarioConfig getDetailedScenarioConfig() {
        return this.detailedScenarioConfig;
    }

    public DetailedConfig.DetailedStepHookConfig getDetailedStepHookConfig() {
        return this.detailedStepHookConfig;
    }

    public void setPassColor(String passColor) {
        this.passColor = passColor;
    }

    public void setFailColor(String failColor) {
        this.failColor = failColor;
    }

    public void setSkipColor(String skipColor) {
        this.skipColor = skipColor;
    }

    public void setDisplayTag(boolean displayTag) {
        this.displayTag = displayTag;
    }

    public void setDisplayDevice(boolean displayDevice) {
        this.displayDevice = displayDevice;
    }

    public void setDisplayAuthor(boolean displayAuthor) {
        this.displayAuthor = displayAuthor;
    }

    public void setDisplayFeature(boolean displayFeature) {
        this.displayFeature = displayFeature;
    }

    public void setDisplayScenario(boolean displayScenario) {
        this.displayScenario = displayScenario;
    }

    public void setDisplayDetailed(boolean displayDetailed) {
        this.displayDetailed = displayDetailed;
    }

    public void setDisplayAttached(boolean displayAttached) {
        this.displayAttached = displayAttached;
    }

    public void setDisplayExpanded(boolean displayExpanded) {
        this.displayExpanded = displayExpanded;
    }

    public void setDashboardConfig(DashboardConfig dashboardConfig) {
        this.dashboardConfig = dashboardConfig;
    }

    public void setFeatureConfig(FeatureConfig featureConfig) {
        this.featureConfig = featureConfig;
    }

    public void setScenarioConfig(ScenarioConfig scenarioConfig) {
        this.scenarioConfig = scenarioConfig;
    }

    public void setNoPassScenarioConfig(NoPassScenarioConfig noPassScenarioConfig) {
        this.noPassScenarioConfig = noPassScenarioConfig;
    }

    public void setSummaryConfig(SummaryConfig summaryConfig) {
        this.summaryConfig = summaryConfig;
    }

    public void setTagConfig(TagConfig tagConfig) {
        this.tagConfig = tagConfig;
    }

    public void setDeviceConfig(DeviceConfig deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    public void setAuthorConfig(AuthorConfig authorConfig) {
        this.authorConfig = authorConfig;
    }

    public void setDetailedFeatureConfig(DetailedConfig.DetailedFeatureConfig detailedFeatureConfig) {
        this.detailedFeatureConfig = detailedFeatureConfig;
    }

    public void setDetailedScenarioConfig(DetailedConfig.DetailedScenarioConfig detailedScenarioConfig) {
        this.detailedScenarioConfig = detailedScenarioConfig;
    }

    public void setDetailedStepHookConfig(DetailedConfig.DetailedStepHookConfig detailedStepHookConfig) {
        this.detailedStepHookConfig = detailedStepHookConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportConfig)) {
            return false;
        }
        ReportConfig other = (ReportConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisplayTag() != other.isDisplayTag()) {
            return false;
        }
        if (this.isDisplayDevice() != other.isDisplayDevice()) {
            return false;
        }
        if (this.isDisplayAuthor() != other.isDisplayAuthor()) {
            return false;
        }
        if (this.isDisplayFeature() != other.isDisplayFeature()) {
            return false;
        }
        if (this.isDisplayScenario() != other.isDisplayScenario()) {
            return false;
        }
        if (this.isDisplayDetailed() != other.isDisplayDetailed()) {
            return false;
        }
        if (this.isDisplayAttached() != other.isDisplayAttached()) {
            return false;
        }
        if (this.isDisplayExpanded() != other.isDisplayExpanded()) {
            return false;
        }
        String this$passColor = this.getPassColor();
        String other$passColor = other.getPassColor();
        if (this$passColor == null ? other$passColor != null : !this$passColor.equals(other$passColor)) {
            return false;
        }
        String this$failColor = this.getFailColor();
        String other$failColor = other.getFailColor();
        if (this$failColor == null ? other$failColor != null : !this$failColor.equals(other$failColor)) {
            return false;
        }
        String this$skipColor = this.getSkipColor();
        String other$skipColor = other.getSkipColor();
        if (this$skipColor == null ? other$skipColor != null : !this$skipColor.equals(other$skipColor)) {
            return false;
        }
        DashboardConfig this$dashboardConfig = this.getDashboardConfig();
        DashboardConfig other$dashboardConfig = other.getDashboardConfig();
        if (this$dashboardConfig == null ? other$dashboardConfig != null : !((Object)this$dashboardConfig).equals(other$dashboardConfig)) {
            return false;
        }
        FeatureConfig this$featureConfig = this.getFeatureConfig();
        FeatureConfig other$featureConfig = other.getFeatureConfig();
        if (this$featureConfig == null ? other$featureConfig != null : !((Object)this$featureConfig).equals(other$featureConfig)) {
            return false;
        }
        ScenarioConfig this$scenarioConfig = this.getScenarioConfig();
        ScenarioConfig other$scenarioConfig = other.getScenarioConfig();
        if (this$scenarioConfig == null ? other$scenarioConfig != null : !((Object)this$scenarioConfig).equals(other$scenarioConfig)) {
            return false;
        }
        NoPassScenarioConfig this$noPassScenarioConfig = this.getNoPassScenarioConfig();
        NoPassScenarioConfig other$noPassScenarioConfig = other.getNoPassScenarioConfig();
        if (this$noPassScenarioConfig == null ? other$noPassScenarioConfig != null : !((Object)this$noPassScenarioConfig).equals(other$noPassScenarioConfig)) {
            return false;
        }
        SummaryConfig this$summaryConfig = this.getSummaryConfig();
        SummaryConfig other$summaryConfig = other.getSummaryConfig();
        if (this$summaryConfig == null ? other$summaryConfig != null : !((Object)this$summaryConfig).equals(other$summaryConfig)) {
            return false;
        }
        TagConfig this$tagConfig = this.getTagConfig();
        TagConfig other$tagConfig = other.getTagConfig();
        if (this$tagConfig == null ? other$tagConfig != null : !((Object)this$tagConfig).equals(other$tagConfig)) {
            return false;
        }
        DeviceConfig this$deviceConfig = this.getDeviceConfig();
        DeviceConfig other$deviceConfig = other.getDeviceConfig();
        if (this$deviceConfig == null ? other$deviceConfig != null : !((Object)this$deviceConfig).equals(other$deviceConfig)) {
            return false;
        }
        AuthorConfig this$authorConfig = this.getAuthorConfig();
        AuthorConfig other$authorConfig = other.getAuthorConfig();
        if (this$authorConfig == null ? other$authorConfig != null : !((Object)this$authorConfig).equals(other$authorConfig)) {
            return false;
        }
        DetailedConfig.DetailedFeatureConfig this$detailedFeatureConfig = this.getDetailedFeatureConfig();
        DetailedConfig.DetailedFeatureConfig other$detailedFeatureConfig = other.getDetailedFeatureConfig();
        if (this$detailedFeatureConfig == null ? other$detailedFeatureConfig != null : !((Object)this$detailedFeatureConfig).equals(other$detailedFeatureConfig)) {
            return false;
        }
        DetailedConfig.DetailedScenarioConfig this$detailedScenarioConfig = this.getDetailedScenarioConfig();
        DetailedConfig.DetailedScenarioConfig other$detailedScenarioConfig = other.getDetailedScenarioConfig();
        if (this$detailedScenarioConfig == null ? other$detailedScenarioConfig != null : !((Object)this$detailedScenarioConfig).equals(other$detailedScenarioConfig)) {
            return false;
        }
        DetailedConfig.DetailedStepHookConfig this$detailedStepHookConfig = this.getDetailedStepHookConfig();
        DetailedConfig.DetailedStepHookConfig other$detailedStepHookConfig = other.getDetailedStepHookConfig();
        return !(this$detailedStepHookConfig == null ? other$detailedStepHookConfig != null : !((Object)this$detailedStepHookConfig).equals(other$detailedStepHookConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisplayTag() ? 79 : 97);
        result = result * 59 + (this.isDisplayDevice() ? 79 : 97);
        result = result * 59 + (this.isDisplayAuthor() ? 79 : 97);
        result = result * 59 + (this.isDisplayFeature() ? 79 : 97);
        result = result * 59 + (this.isDisplayScenario() ? 79 : 97);
        result = result * 59 + (this.isDisplayDetailed() ? 79 : 97);
        result = result * 59 + (this.isDisplayAttached() ? 79 : 97);
        result = result * 59 + (this.isDisplayExpanded() ? 79 : 97);
        String $passColor = this.getPassColor();
        result = result * 59 + ($passColor == null ? 43 : $passColor.hashCode());
        String $failColor = this.getFailColor();
        result = result * 59 + ($failColor == null ? 43 : $failColor.hashCode());
        String $skipColor = this.getSkipColor();
        result = result * 59 + ($skipColor == null ? 43 : $skipColor.hashCode());
        DashboardConfig $dashboardConfig = this.getDashboardConfig();
        result = result * 59 + ($dashboardConfig == null ? 43 : ((Object)$dashboardConfig).hashCode());
        FeatureConfig $featureConfig = this.getFeatureConfig();
        result = result * 59 + ($featureConfig == null ? 43 : ((Object)$featureConfig).hashCode());
        ScenarioConfig $scenarioConfig = this.getScenarioConfig();
        result = result * 59 + ($scenarioConfig == null ? 43 : ((Object)$scenarioConfig).hashCode());
        NoPassScenarioConfig $noPassScenarioConfig = this.getNoPassScenarioConfig();
        result = result * 59 + ($noPassScenarioConfig == null ? 43 : ((Object)$noPassScenarioConfig).hashCode());
        SummaryConfig $summaryConfig = this.getSummaryConfig();
        result = result * 59 + ($summaryConfig == null ? 43 : ((Object)$summaryConfig).hashCode());
        TagConfig $tagConfig = this.getTagConfig();
        result = result * 59 + ($tagConfig == null ? 43 : ((Object)$tagConfig).hashCode());
        DeviceConfig $deviceConfig = this.getDeviceConfig();
        result = result * 59 + ($deviceConfig == null ? 43 : ((Object)$deviceConfig).hashCode());
        AuthorConfig $authorConfig = this.getAuthorConfig();
        result = result * 59 + ($authorConfig == null ? 43 : ((Object)$authorConfig).hashCode());
        DetailedConfig.DetailedFeatureConfig $detailedFeatureConfig = this.getDetailedFeatureConfig();
        result = result * 59 + ($detailedFeatureConfig == null ? 43 : ((Object)$detailedFeatureConfig).hashCode());
        DetailedConfig.DetailedScenarioConfig $detailedScenarioConfig = this.getDetailedScenarioConfig();
        result = result * 59 + ($detailedScenarioConfig == null ? 43 : ((Object)$detailedScenarioConfig).hashCode());
        DetailedConfig.DetailedStepHookConfig $detailedStepHookConfig = this.getDetailedStepHookConfig();
        result = result * 59 + ($detailedStepHookConfig == null ? 43 : ((Object)$detailedStepHookConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ReportConfig(passColor=" + this.getPassColor() + ", failColor=" + this.getFailColor() + ", skipColor=" + this.getSkipColor() + ", displayTag=" + this.isDisplayTag() + ", displayDevice=" + this.isDisplayDevice() + ", displayAuthor=" + this.isDisplayAuthor() + ", displayFeature=" + this.isDisplayFeature() + ", displayScenario=" + this.isDisplayScenario() + ", displayDetailed=" + this.isDisplayDetailed() + ", displayAttached=" + this.isDisplayAttached() + ", displayExpanded=" + this.isDisplayExpanded() + ", dashboardConfig=" + this.getDashboardConfig() + ", featureConfig=" + this.getFeatureConfig() + ", scenarioConfig=" + this.getScenarioConfig() + ", noPassScenarioConfig=" + this.getNoPassScenarioConfig() + ", summaryConfig=" + this.getSummaryConfig() + ", tagConfig=" + this.getTagConfig() + ", deviceConfig=" + this.getDeviceConfig() + ", authorConfig=" + this.getAuthorConfig() + ", detailedFeatureConfig=" + this.getDetailedFeatureConfig() + ", detailedScenarioConfig=" + this.getDetailedScenarioConfig() + ", detailedStepHookConfig=" + this.getDetailedStepHookConfig() + ")";
    }

    public static class AuthorConfig
    extends AttributeConfig {
    }

    public static class DeviceConfig
    extends AttributeConfig {
    }

    public static class TagConfig
    extends AttributeConfig {
    }

    public static abstract class AttributeConfig {
        private String totalColor;

        public int dataCount() {
            return 20;
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeConfig)) {
                return false;
            }
            AttributeConfig other = (AttributeConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            return !(this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttributeConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            return result;
        }

        public String toString() {
            return "ReportConfig.AttributeConfig(totalColor=" + this.getTotalColor() + ")";
        }
    }

    public static class SummaryConfig {
        private String totalColor;
        private String durationColor;

        public int dataCount() {
            return 20;
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public Color durationColor() {
            return ReportConfig.createColor(this.durationColor, Color.BLACK);
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public String getDurationColor() {
            return this.durationColor;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public void setDurationColor(String durationColor) {
            this.durationColor = durationColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SummaryConfig)) {
                return false;
            }
            SummaryConfig other = (SummaryConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            if (this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor)) {
                return false;
            }
            String this$durationColor = this.getDurationColor();
            String other$durationColor = other.getDurationColor();
            return !(this$durationColor == null ? other$durationColor != null : !this$durationColor.equals(other$durationColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SummaryConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            String $durationColor = this.getDurationColor();
            result = result * 59 + ($durationColor == null ? 43 : $durationColor.hashCode());
            return result;
        }

        public String toString() {
            return "ReportConfig.SummaryConfig(totalColor=" + this.getTotalColor() + ", durationColor=" + this.getDurationColor() + ")";
        }
    }

    public static class NoPassScenarioConfig {
        private String scenarioCount;
        private final int defaultCount = 10;

        public int scenarioCount() {
            return ReportConfig.createCount(this.scenarioCount, 10);
        }

        public String getScenarioCount() {
            return this.scenarioCount;
        }

        public int getDefaultCount() {
            return this.defaultCount;
        }

        public void setScenarioCount(String scenarioCount) {
            this.scenarioCount = scenarioCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NoPassScenarioConfig)) {
                return false;
            }
            NoPassScenarioConfig other = (NoPassScenarioConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultCount() != other.getDefaultCount()) {
                return false;
            }
            String this$scenarioCount = this.getScenarioCount();
            String other$scenarioCount = other.getScenarioCount();
            return !(this$scenarioCount == null ? other$scenarioCount != null : !this$scenarioCount.equals(other$scenarioCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NoPassScenarioConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefaultCount();
            String $scenarioCount = this.getScenarioCount();
            result = result * 59 + ($scenarioCount == null ? 43 : $scenarioCount.hashCode());
            return result;
        }

        public String toString() {
            return "ReportConfig.NoPassScenarioConfig(scenarioCount=" + this.getScenarioCount() + ", defaultCount=" + this.getDefaultCount() + ")";
        }
    }

    public static class ScenarioConfig {
        private String scenarioCount;
        private String totalColor;
        private String durationColor;
        private final int defaultCount = 10;

        public int scenarioCount() {
            return ReportConfig.createCount(this.scenarioCount, 10);
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public Color durationColor() {
            return ReportConfig.createColor(this.durationColor, Color.BLACK);
        }

        public String getScenarioCount() {
            return this.scenarioCount;
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public String getDurationColor() {
            return this.durationColor;
        }

        public int getDefaultCount() {
            return this.defaultCount;
        }

        public void setScenarioCount(String scenarioCount) {
            this.scenarioCount = scenarioCount;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public void setDurationColor(String durationColor) {
            this.durationColor = durationColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScenarioConfig)) {
                return false;
            }
            ScenarioConfig other = (ScenarioConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultCount() != other.getDefaultCount()) {
                return false;
            }
            String this$scenarioCount = this.getScenarioCount();
            String other$scenarioCount = other.getScenarioCount();
            if (this$scenarioCount == null ? other$scenarioCount != null : !this$scenarioCount.equals(other$scenarioCount)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            if (this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor)) {
                return false;
            }
            String this$durationColor = this.getDurationColor();
            String other$durationColor = other.getDurationColor();
            return !(this$durationColor == null ? other$durationColor != null : !this$durationColor.equals(other$durationColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScenarioConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefaultCount();
            String $scenarioCount = this.getScenarioCount();
            result = result * 59 + ($scenarioCount == null ? 43 : $scenarioCount.hashCode());
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            String $durationColor = this.getDurationColor();
            result = result * 59 + ($durationColor == null ? 43 : $durationColor.hashCode());
            return result;
        }

        public String toString() {
            return "ReportConfig.ScenarioConfig(scenarioCount=" + this.getScenarioCount() + ", totalColor=" + this.getTotalColor() + ", durationColor=" + this.getDurationColor() + ", defaultCount=" + this.getDefaultCount() + ")";
        }
    }

    public static class FeatureConfig {
        private String featureCount;
        private String totalColor;
        private String durationColor;
        private final int defaultCount = 10;

        public int featureCount() {
            return ReportConfig.createCount(this.featureCount, 10);
        }

        public Color totalColor() {
            return ReportConfig.createColor(this.totalColor, Color.BLACK);
        }

        public Color durationColor() {
            return ReportConfig.createColor(this.durationColor, Color.BLACK);
        }

        public String getFeatureCount() {
            return this.featureCount;
        }

        public String getTotalColor() {
            return this.totalColor;
        }

        public String getDurationColor() {
            return this.durationColor;
        }

        public int getDefaultCount() {
            return this.defaultCount;
        }

        public void setFeatureCount(String featureCount) {
            this.featureCount = featureCount;
        }

        public void setTotalColor(String totalColor) {
            this.totalColor = totalColor;
        }

        public void setDurationColor(String durationColor) {
            this.durationColor = durationColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig other = (FeatureConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefaultCount() != other.getDefaultCount()) {
                return false;
            }
            String this$featureCount = this.getFeatureCount();
            String other$featureCount = other.getFeatureCount();
            if (this$featureCount == null ? other$featureCount != null : !this$featureCount.equals(other$featureCount)) {
                return false;
            }
            String this$totalColor = this.getTotalColor();
            String other$totalColor = other.getTotalColor();
            if (this$totalColor == null ? other$totalColor != null : !this$totalColor.equals(other$totalColor)) {
                return false;
            }
            String this$durationColor = this.getDurationColor();
            String other$durationColor = other.getDurationColor();
            return !(this$durationColor == null ? other$durationColor != null : !this$durationColor.equals(other$durationColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FeatureConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefaultCount();
            String $featureCount = this.getFeatureCount();
            result = result * 59 + ($featureCount == null ? 43 : $featureCount.hashCode());
            String $totalColor = this.getTotalColor();
            result = result * 59 + ($totalColor == null ? 43 : $totalColor.hashCode());
            String $durationColor = this.getDurationColor();
            result = result * 59 + ($durationColor == null ? 43 : $durationColor.hashCode());
            return result;
        }

        public String toString() {
            return "ReportConfig.FeatureConfig(featureCount=" + this.getFeatureCount() + ", totalColor=" + this.getTotalColor() + ", durationColor=" + this.getDurationColor() + ", defaultCount=" + this.getDefaultCount() + ")";
        }
    }
}

