/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.config;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.pdf.config.DetailedConfig;
import tech.grasshopper.pdf.config.ReportConfig;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Hook;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;

public class StepHookFilter {
    public static List<Executable> allExecutables(List<Step> steps, List<Hook> before, List<Hook> after) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        before.forEach(h -> executables.add((Executable)h));
        steps.forEach(s -> {
            s.getBefore().forEach(h -> executables.add((Executable)h));
            executables.add((Executable)s);
            s.getAfter().forEach(h -> executables.add((Executable)h));
        });
        after.forEach(h -> executables.add((Executable)h));
        return executables;
    }

    public static List<Executable> filterExecutables(ReportConfig reportConfig, List<Step> steps, List<Hook> before, List<Hook> after) {
        DetailedConfig.DetailedStepHookConfig detailedStepHookConfig = reportConfig.getDetailedStepHookConfig();
        ArrayList<Executable> executables = new ArrayList<Executable>();
        before.forEach(h -> {
            if (!detailedStepHookConfig.isSkipScenarioBeforeHooks() || h.getStatus() != Status.PASSED) {
                executables.add((Executable)h);
            }
        });
        steps.forEach(s -> {
            s.getBefore().forEach(h -> {
                if (!detailedStepHookConfig.isSkipStepBeforeHooks() || h.getStatus() != Status.PASSED) {
                    executables.add((Executable)h);
                }
            });
            executables.add((Executable)s);
            s.getAfter().forEach(h -> {
                if (!detailedStepHookConfig.isSkipStepAfterHooks() || h.getStatus() != Status.PASSED) {
                    executables.add((Executable)h);
                }
            });
        });
        after.forEach(h -> {
            if (!detailedStepHookConfig.isSkipScenarioAfterHooks() || h.getStatus() != Status.PASSED) {
                executables.add((Executable)h);
            }
        });
        return executables;
    }
}

