/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details;

import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.section.details.DetailedFeatureDisplay;
import tech.grasshopper.pdf.section.details.DetailedScenarioDisplay;
import tech.grasshopper.pdf.section.details.DetailedStepHookDisplay;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.Section;

public class DetailedSection
extends Section {
    static final String SECTION_TITLE = "DETAILED SECTION";
    protected FeatureData detailedData;
    protected static final float GAP = 10.0f;
    protected static float ylocation = 550.0f;

    @Override
    public void createSection() {
        this.detailedData = (FeatureData)this.displayData;
        if (this.detailedData.getFeatures().isEmpty()) {
            return;
        }
        PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument(SECTION_TITLE);
        for (Feature feature : this.detailedData.getFeatures()) {
            Display featureDisplay = ((DetailedFeatureDisplay.DetailedFeatureDisplayBuilder)((DetailedFeatureDisplay.DetailedFeatureDisplayBuilder)((DetailedFeatureDisplay.DetailedFeatureDisplayBuilder)((Display.DisplayBuilder)DetailedFeatureDisplay.builder().feature(feature)).ylocation(ylocation)).document(this.document)).reportConfig(this.reportConfig)).build();
            ((DetailedFeatureDisplay)featureDisplay).display();
            ylocation = ((DetailedFeatureDisplay)featureDisplay).getFinalY() - 10.0f;
            this.featureAdditionalInfoDisplay(feature);
            for (Scenario scenario : feature.getScenarios()) {
                Display scenarioDisplay = ((DetailedScenarioDisplay.DetailedScenarioDisplayBuilder)((DetailedScenarioDisplay.DetailedScenarioDisplayBuilder)((DetailedScenarioDisplay.DetailedScenarioDisplayBuilder)((Display.DisplayBuilder)((DetailedScenarioDisplay.DetailedScenarioDisplayBuilder)DetailedScenarioDisplay.builder().feature(feature)).scenario(scenario)).ylocation(ylocation)).document(this.document)).reportConfig(this.reportConfig)).build();
                ((DetailedScenarioDisplay)scenarioDisplay).display();
                ylocation = ((DetailedScenarioDisplay)scenarioDisplay).getFinalY() - 10.0f;
                this.scenarioAdditionalInfoDisplay(scenario);
                Display stepHookDisplay = ((DetailedStepHookDisplay.DetailedStepHookDisplayBuilder)((DetailedStepHookDisplay.DetailedStepHookDisplayBuilder)((DetailedStepHookDisplay.DetailedStepHookDisplayBuilder)((Display.DisplayBuilder)DetailedStepHookDisplay.builder().executables(scenario.getFilteredStepsAndHooks(this.reportConfig))).ylocation(ylocation)).document(this.document)).reportConfig(this.reportConfig)).build();
                ((DetailedStepHookDisplay)stepHookDisplay).display();
                ylocation = ((DetailedStepHookDisplay)stepHookDisplay).getFinalY() - 10.0f;
            }
        }
    }

    protected void featureAdditionalInfoDisplay(Feature feature) {
    }

    protected void scenarioAdditionalInfoDisplay(Scenario scenario) {
    }

    protected DetailedSection(DetailedSectionBuilder<?, ?> b) {
        super(b);
        this.detailedData = ((DetailedSectionBuilder)b).detailedData;
    }

    public static DetailedSectionBuilder<?, ?> builder() {
        return new DetailedSectionBuilderImpl();
    }

    public void setDetailedData(FeatureData detailedData) {
        this.detailedData = detailedData;
    }

    @Override
    public String toString() {
        return "DetailedSection(detailedData=" + this.getDetailedData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetailedSection)) {
            return false;
        }
        DetailedSection other = (DetailedSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FeatureData this$detailedData = this.getDetailedData();
        FeatureData other$detailedData = other.getDetailedData();
        return !(this$detailedData == null ? other$detailedData != null : !this$detailedData.equals(other$detailedData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DetailedSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FeatureData $detailedData = this.getDetailedData();
        result = result * 59 + ($detailedData == null ? 43 : $detailedData.hashCode());
        return result;
    }

    public FeatureData getDetailedData() {
        return this.detailedData;
    }

    private static final class DetailedSectionBuilderImpl
    extends DetailedSectionBuilder<DetailedSection, DetailedSectionBuilderImpl> {
        private DetailedSectionBuilderImpl() {
        }

        @Override
        protected DetailedSectionBuilderImpl self() {
            return this;
        }

        @Override
        public DetailedSection build() {
            return new DetailedSection(this);
        }
    }

    public static abstract class DetailedSectionBuilder<C extends DetailedSection, B extends DetailedSectionBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private FeatureData detailedData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B detailedData(FeatureData detailedData) {
            this.detailedData = detailedData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DetailedSection.DetailedSectionBuilder(super=" + super.toString() + ", detailedData=" + this.detailedData + ")";
        }
    }
}

