/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.details.executable.table;

import java.awt.Color;
import java.util.List;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Row;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;

public class TableCellWithMessage {
    private Color textColor;
    private Color backgroundColor;
    private int fontsize;
    private boolean columnsCropped;
    private boolean cellTextCropped;
    private List<Float> maximumColumnTextWidths;
    private List<Row> rows;
    private List<Float> columnTextWidths;
    private static final float PADDING = 3.0f;
    private static final float INDICATOR_COLUMN_WIDTH = 4.0f;

    public AbstractCell createTableCell() {
        Table.TableBuilder tableBuilder = Table.builder().backgroundColor(this.backgroundColor).font(ReportFont.REGULAR_FONT).fontSize(Integer.valueOf(this.fontsize)).borderColor(Color.GRAY).borderWidth(1.0f).padding(3.0f);
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        TextLengthOptimizer optimizer = TextLengthOptimizer.builder().font(ReportFont.REGULAR_FONT).fontsize(this.fontsize).build();
        this.addColumnWidthsToTable(tableBuilder, this.columnTextWidths);
        boolean firstRow = true;
        for (Row row : this.rows) {
            Row.RowBuilder rowBuilder = org.vandeseer.easytable.structure.Row.builder();
            for (int i = 0; i < this.columnTextWidths.size(); ++i) {
                optimizer.setAvailableSpace(this.columnTextWidths.get(i).floatValue());
                rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().textColor(this.textColor)).text(sanitizer.sanitizeText(optimizer.optimizeText(row.getCells().get(i)))).build());
                if (!optimizer.isTextTrimmed()) continue;
                this.cellTextCropped = optimizer.isTextTrimmed();
            }
            this.croppedColumnIndicatorCells(rowBuilder, firstRow);
            if (firstRow) {
                firstRow = false;
            }
            tableBuilder.addRow(rowBuilder.build());
        }
        this.croppedMessage(tableBuilder, this.columnTextWidths, sanitizer.getStripMessage());
        return ((TableWithinTableCell.TableWithinTableCellBuilder)((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(tableBuilder.build()).borderColor(Color.GRAY)).borderWidth(1.0f)).build();
    }

    private void addColumnWidthsToTable(Table.TableBuilder tableBuilder, List<Float> columnTextWidths) {
        columnTextWidths.forEach(w -> tableBuilder.addColumnOfWidth(w.floatValue() + 6.0f));
        if (this.columnsCropped) {
            tableBuilder.addColumnOfWidth(10.0f);
        }
    }

    private void croppedColumnIndicatorCells(Row.RowBuilder rowBuilder, boolean firstRow) {
        if (this.columnsCropped) {
            if (firstRow) {
                rowBuilder.add((AbstractCell)TextCell.builder().text("*").build());
            } else {
                rowBuilder.add((AbstractCell)TextCell.builder().text("").build());
            }
        }
    }

    private void croppedMessage(Table.TableBuilder tableBuilder, List<Float> columnTextWidths, String sanitizerMessage) {
        if (sanitizerMessage.isEmpty() && !this.cellTextCropped && !this.columnsCropped) {
            return;
        }
        String croppedMsgPrefix = sanitizerMessage.isEmpty() ? "* The" : " The";
        String croppedMsgSuffix = "have been cropped to fit in the available space.";
        Object message = "";
        int colSpan = columnTextWidths.size();
        if (this.cellTextCropped) {
            message = " data cell text(s) ";
        }
        if (this.columnsCropped) {
            if (this.cellTextCropped) {
                message = (String)message + "and";
            }
            message = (String)message + " extra column(s) ";
            ++colSpan;
        }
        tableBuilder.addRow(org.vandeseer.easytable.structure.Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(sanitizerMessage + croppedMsgPrefix + (String)message + croppedMsgSuffix).colSpan(colSpan)).textColor(this.textColor)).build()).build());
    }

    private static Color $default$backgroundColor() {
        return Color.WHITE;
    }

    TableCellWithMessage(Color textColor, Color backgroundColor, int fontsize, boolean columnsCropped, boolean cellTextCropped, List<Float> maximumColumnTextWidths, List<Row> rows, List<Float> columnTextWidths) {
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
        this.fontsize = fontsize;
        this.columnsCropped = columnsCropped;
        this.cellTextCropped = cellTextCropped;
        this.maximumColumnTextWidths = maximumColumnTextWidths;
        this.rows = rows;
        this.columnTextWidths = columnTextWidths;
    }

    public static TableCellWithMessageBuilder builder() {
        return new TableCellWithMessageBuilder();
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public void setColumnTextWidths(List<Float> columnTextWidths) {
        this.columnTextWidths = columnTextWidths;
    }

    public static class TableCellWithMessageBuilder {
        private Color textColor;
        private boolean backgroundColor$set;
        private Color backgroundColor$value;
        private int fontsize;
        private boolean columnsCropped;
        private boolean cellTextCropped;
        private List<Float> maximumColumnTextWidths;
        private List<Row> rows;
        private List<Float> columnTextWidths;

        TableCellWithMessageBuilder() {
        }

        public TableCellWithMessageBuilder textColor(Color textColor) {
            this.textColor = textColor;
            return this;
        }

        public TableCellWithMessageBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor$value = backgroundColor;
            this.backgroundColor$set = true;
            return this;
        }

        public TableCellWithMessageBuilder fontsize(int fontsize) {
            this.fontsize = fontsize;
            return this;
        }

        public TableCellWithMessageBuilder columnsCropped(boolean columnsCropped) {
            this.columnsCropped = columnsCropped;
            return this;
        }

        public TableCellWithMessageBuilder cellTextCropped(boolean cellTextCropped) {
            this.cellTextCropped = cellTextCropped;
            return this;
        }

        public TableCellWithMessageBuilder maximumColumnTextWidths(List<Float> maximumColumnTextWidths) {
            this.maximumColumnTextWidths = maximumColumnTextWidths;
            return this;
        }

        public TableCellWithMessageBuilder rows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public TableCellWithMessageBuilder columnTextWidths(List<Float> columnTextWidths) {
            this.columnTextWidths = columnTextWidths;
            return this;
        }

        public TableCellWithMessage build() {
            Color backgroundColor$value = this.backgroundColor$value;
            if (!this.backgroundColor$set) {
                backgroundColor$value = TableCellWithMessage.$default$backgroundColor();
            }
            return new TableCellWithMessage(this.textColor, backgroundColor$value, this.fontsize, this.columnsCropped, this.cellTextCropped, this.maximumColumnTextWidths, this.rows, this.columnTextWidths);
        }

        public String toString() {
            return "TableCellWithMessage.TableCellWithMessageBuilder(textColor=" + this.textColor + ", backgroundColor$value=" + this.backgroundColor$value + ", fontsize=" + this.fontsize + ", columnsCropped=" + this.columnsCropped + ", cellTextCropped=" + this.cellTextCropped + ", maximumColumnTextWidths=" + this.maximumColumnTextWidths + ", rows=" + this.rows + ", columnTextWidths=" + this.columnTextWidths + ")";
        }
    }
}

