/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.summary;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.destination.Destination;
import tech.grasshopper.pdf.destination.DestinationAware;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.pdf.structure.footer.CroppedMessage;
import tech.grasshopper.pdf.structure.paginate.PaginatedDisplay;
import tech.grasshopper.pdf.util.DateUtil;
import tech.grasshopper.pdf.util.TextUtil;

public class SummaryDisplay
extends PaginatedDisplay
implements DestinationAware {
    private Table.TableBuilder tableBuilder;
    private static final int TABLE_Y_AXIS_START = 530;
    private static final int TABLE_Y_AXIS_END = 60;
    private static final PDFont HEADER_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int HEADER_FONT_SIZE = 14;
    private static final PDFont NAME_FONT = ReportFont.ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 12;
    private static final PDFont DATA_FONT = ReportFont.ITALIC_FONT;
    private static final int DATA_FONT_SIZE = 11;
    private static final float FEATURE_NAME_COLUMN_WIDTH = 380.0f;
    private static final float HEADER_PADDING = 9.0f;
    private static final float FEATURE_PADDING = 8.0f;
    private static final float DATA_PADDING = 5.0f;
    public static final float TABLE_SPACE = 470.0f;
    public static final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(12).availableSpace(364.0f).maxLines(2).build();
    private static final String CROPPED_MESSAGE = "* The feature name has been cropped to fit in the available space.";
    private boolean nameCropped;

    public static float headerRowHeight() {
        return TextUtil.builder().font(HEADER_FONT).fontSize(14).text("Feature").width(380.0f).padding(9.0f).build().tableRowHeight() * 2.0f;
    }

    public static TextUtil featureNameTextUtil() {
        return TextUtil.builder().font(NAME_FONT).fontSize(12).text("").width(380.0f).padding(8.0f).build();
    }

    @Override
    public void display() {
        this.page = PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument("SUMMARY");
        this.content = new PDPageContentStream(this.document, this.page, PDPageContentStream.AppendMode.APPEND, true);
        this.createTableBuilder();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
        this.croppedMessageDisplay();
        this.createDestination();
        this.content.close();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{380.0f, 100.0f, 35.0f, 35.0f, 35.0f, 35.0f, 35.0f, 35.0f, 35.0f, 35.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().padding(9.0f).horizontalAlignment(HorizontalAlignment.CENTER).font(HEADER_FONT).fontSize(Integer.valueOf(14)).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature").colSpan(2)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Scenario").colSpan(4)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Step").colSpan(4)).build()).build()).addRow(Row.builder().padding(9.0f).horizontalAlignment(HorizontalAlignment.CENTER).font(HEADER_FONT).fontSize(Integer.valueOf(14)).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)TextCell.builder().text("Name").build()).add((AbstractCell)TextCell.builder().text("Duration").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getScenarioConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).build());
    }

    private void createDataRows() {
        FeatureData featureData = (FeatureData)this.displayData;
        List<Feature> features = featureData.getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            this.tableBuilder.addRow(Row.builder().padding(5.0f).font(DATA_FONT).fontSize(Integer.valueOf(11)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).add(this.createFeatureNameCell(feature)).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.durationValue(feature.calculatedDuration())).textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getTotalScenarios())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getPassedScenarios())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getFailedScenarios())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getSkippedScenarios())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getTotalSteps())).textColor(this.reportConfig.getScenarioConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getPassedSteps())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getFailedSteps())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getSkippedSteps())).textColor(this.reportConfig.skippedColor())).build()).build());
        }
    }

    private void drawTable() {
        Object tableDrawer = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(this.tableBuilder)).document(this.document)).startX(40.0f)).startY(530.0f)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageSupplier())).build();
        ((TableCreator)tableDrawer).displayTable();
    }

    private AbstractCell createFeatureNameCell(Feature feature) {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        String featureName = sanitizer.sanitizeText(featureNameTextOptimizer.optimizeTextLines(feature.getName()));
        if (featureNameTextOptimizer.isTextTrimmed()) {
            this.nameCropped = true;
        }
        if (this.reportConfig.isDisplayDetailed()) {
            Annotation annotation = Annotation.builder().title(sanitizer.sanitizeText(feature.getName())).build();
            feature.addAnnotation(annotation);
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).text(featureName)).padding(8.0f)).font(NAME_FONT)).fontSize(Integer.valueOf(12))).horizontalAlignment(HorizontalAlignment.LEFT)).textColor(this.statusColor(feature.getStatus()))).build();
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(featureName).padding(8.0f)).font(NAME_FONT)).fontSize(Integer.valueOf(12))).horizontalAlignment(HorizontalAlignment.LEFT)).textColor(this.statusColor(feature.getStatus()))).build();
    }

    private void croppedMessageDisplay() {
        if (this.nameCropped) {
            CroppedMessage.builder().content(this.content).message(CROPPED_MESSAGE).build().displayMessage();
        }
    }

    @Override
    public void createDestination() {
        Destination destination = Destination.builder().name("SUMMARY - " + (this.paginationData.getItemFromIndex() + 1) + " to " + this.paginationData.getItemToIndex()).yCoord((int)this.page.getMediaBox().getHeight()).page(this.page).build();
        this.destinations.addSummaryDestination(destination);
    }

    protected SummaryDisplay(SummaryDisplayBuilder<?, ?> b) {
        super((PaginatedDisplay.PaginatedDisplayBuilder<?, ?>)b);
        this.tableBuilder = b.tableBuilder;
        this.nameCropped = b.nameCropped;
    }

    public static SummaryDisplayBuilder<?, ?> builder() {
        return new SummaryDisplayBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryDisplay)) {
            return false;
        }
        SummaryDisplay other = (SummaryDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nameCropped != other.nameCropped) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.tableBuilder;
        Table.TableBuilder other$tableBuilder = other.tableBuilder;
        return !(this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nameCropped ? 79 : 97);
        Table.TableBuilder $tableBuilder = this.tableBuilder;
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        return result;
    }

    private static final class SummaryDisplayBuilderImpl
    extends SummaryDisplayBuilder<SummaryDisplay, SummaryDisplayBuilderImpl> {
        private SummaryDisplayBuilderImpl() {
        }

        @Override
        protected SummaryDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public SummaryDisplay build() {
            return new SummaryDisplay(this);
        }
    }

    public static abstract class SummaryDisplayBuilder<C extends SummaryDisplay, B extends SummaryDisplayBuilder<C, B>>
    extends PaginatedDisplay.PaginatedDisplayBuilder<C, B> {
        private Table.TableBuilder tableBuilder;
        private boolean nameCropped;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B nameCropped(boolean nameCropped) {
            this.nameCropped = nameCropped;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SummaryDisplay.SummaryDisplayBuilder(super=" + super.toString() + ", tableBuilder=" + this.tableBuilder + ", nameCropped=" + this.nameCropped + ")";
        }
    }
}

