/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.cell;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellValueOptions;
import tech.grasshopper.extent.data.pojo.Status;

public class CellOperations {
    private XSSFSheet sheet;

    public void writePlainValue(String cellName, String cellValue) {
        CellReference cellReference = new CellReference(cellName);
        Cell cell = this.fetchOrCreateCell(cellReference);
        cell.setCellValue(cellValue);
    }

    public void writePlainPositiveNumberValue(String cellName, Long cellValue) {
        CellReference cellReference = new CellReference(cellName);
        Cell cell = this.fetchOrCreateCell(cellReference);
        if (cellValue > 0L) {
            cell.setCellValue((double)cellValue.longValue());
        } else {
            cell.setBlank();
        }
    }

    public void writeValue(String cellName, String cellValue, CellValueOptions options) {
        CellReference cellReference = new CellReference(cellName);
        this.writeValue(cellReference, cellValue, options);
    }

    public void writeValue(CellReference cellReference, String cellValue, CellValueOptions options) {
        boolean numberPresent;
        Cell cell = this.fetchOrCreateCell(cellReference);
        CellStyle style = cell.getCellStyle();
        XSSFFont font = this.sheet.getWorkbook().createFont();
        boolean bl = numberPresent = options.isNumber() || options.isPositiveNumber();
        if (options.isBold()) {
            font.setBold(true);
        }
        if (options.isItalic()) {
            font.setItalic(true);
        }
        if (options.getTextColor() != null) {
            font.setColor(new XSSFColor(options.getTextColor(), null));
        }
        if (options.getHorizAlign() != null) {
            style.setAlignment(options.getHorizAlign());
        }
        if (options.getVertAlign() != null) {
            style.setVerticalAlignment(options.getVertAlign());
        }
        if (options.isStatus()) {
            font.setColor(new XSSFColor(Status.getStatusColor(Status.valueOf(cellValue)), null));
        }
        style.setFont((Font)font);
        if (numberPresent) {
            Long value = Long.parseLong(cellValue);
            if (options.isPositiveNumber() && value < 1L) {
                cell.setBlank();
            } else {
                cell.setCellValue((double)value.longValue());
            }
        } else {
            cell.setCellValue(cellValue);
        }
    }

    private Cell fetchOrCreateCell(CellReference cellRef) {
        Cell cell;
        XSSFRow row = this.sheet.getRow(cellRef.getRow());
        if (row == null) {
            row = this.sheet.createRow(cellRef.getRow());
        }
        if ((cell = row.getCell((int)cellRef.getCol())) == null) {
            cell = row.createCell((int)cellRef.getCol());
        }
        return cell;
    }

    public void mergeRows(int startRow, int rowsToMerge, int startColumn, int colsToMerge) {
        if (rowsToMerge == 1 && colsToMerge == 1) {
            return;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(startRow, startRow + rowsToMerge - 1, startColumn, startColumn + colsToMerge - 1));
    }

    public CellStyle createCellStyle() {
        XSSFCellStyle style = this.sheet.getWorkbook().createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setBorderTop(BorderStyle.HAIR);
        style.setBorderRight(BorderStyle.HAIR);
        style.setBorderBottom(BorderStyle.HAIR);
        style.setBorderLeft(BorderStyle.HAIR);
        style.setWrapText(true);
        return style;
    }

    public void createCellsWithStyleInRange(int startRow, int endRow, int startCol, int endCol) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startCol; j < endCol; ++j) {
                CellReference cellRef = new CellReference(i, j);
                Cell cell = this.fetchOrCreateCell(cellRef);
                CellStyle style = this.createCellStyle();
                cell.setCellStyle(style);
            }
        }
    }

    CellOperations(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public static CellOperationsBuilder builder() {
        return new CellOperationsBuilder();
    }

    public static class CellOperationsBuilder {
        private XSSFSheet sheet;

        CellOperationsBuilder() {
        }

        public CellOperationsBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public CellOperations build() {
            return new CellOperations(this.sheet);
        }

        public String toString() {
            return "CellOperations.CellOperationsBuilder(sheet=" + this.sheet + ")";
        }
    }
}

