/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellValueOptions;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.ComponentShifter;
import tech.grasshopper.excel.report.sheets.Sheet;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.excel.report.table.TagFeatureScenarioTable;
import tech.grasshopper.extent.data.SheetData;

public class TagsSheet
extends Sheet {
    private static final String TAGS_COUNT_TABLE_NAME_CELL = "B22";
    private static final String TAGS_COUNT_TABLE_SCENARIO_PASSED_CELL = "D22";
    private static final String TAGS_COUNT_TABLE_SCENARIO_FAILED_CELL = "E22";
    private static final String TAGS_COUNT_TABLE_SCENARIO_SKIPPED_CELL = "F22";
    private static final String TAGS_TABLE_NAME_CELL = "B26";
    private static final String TAGS_CHART = "Tags";

    @Override
    public void updateSheet() {
        this.sheet = this.workbook.getSheet(TAGS_CHART);
        if (this.reportData.getTagData().isEmpty()) {
            this.deleteSheet(TAGS_CHART);
            return;
        }
        this.moveDownTagsFeatureScenarioTable(this.sheet, this.reportData.getTagData().size());
        this.updateTagsTableData();
        this.refreshTagsChartPlot();
        CellReference origCellRef = new CellReference(TAGS_TABLE_NAME_CELL);
        CellReference cellRef = new CellReference(origCellRef.getRow() + this.reportData.getTagData().size(), origCellRef.getCol());
        this.updateTagsFeatureScenarioTableData(cellRef);
        this.sheet.createFreezePane(0, 21);
    }

    private void moveDownTagsFeatureScenarioTable(XSSFSheet sheet, int tagRowCount) {
        CellReference celRef = new CellReference(TAGS_COUNT_TABLE_NAME_CELL);
        ComponentShifter.shiftRows(sheet, celRef.getRow() + 1, tagRowCount);
    }

    private void updateTagsTableData() {
        SimpleTableOperations<SheetData.TagCountData> scenarioTableOperations = SimpleTableOperations.builder().sheet(this.sheet).build();
        Function<SheetData.TagCountData, List> rowValueTransformer = t -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = t.getScenarioCounts();
            row.add(t.getName());
            row.add(String.valueOf(counts.getTotal()));
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            row.add(counts.getPassPercent());
            return row;
        };
        ArrayList<CellValueOptions> cellOptions = new ArrayList<CellValueOptions>();
        cellOptions.add(CellValueOptions.BOLD_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_STATUSPASSEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_STATUSFAILEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.POSITIVENUMBER_STATUSSKIPPEDTEXTCOLOR_HORIZCENTER_CELL_OPTIONS);
        cellOptions.add(CellValueOptions.BOLD_HORIZCENTER_CELL_OPTIONS);
        scenarioTableOperations.writeTableCellValues(TAGS_COUNT_TABLE_NAME_CELL, this.reportData.getTagData(), rowValueTransformer, cellOptions);
    }

    private void refreshTagsChartPlot() {
        ChartOperations chartOperations = ChartOperations.builder().dataSheet(this.sheet).chartSheet(this.sheet).build();
        int rows = this.reportData.getTagData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(TAGS_COUNT_TABLE_NAME_CELL, rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(TAGS_COUNT_TABLE_SCENARIO_PASSED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(TAGS_COUNT_TABLE_SCENARIO_SKIPPED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(TAGS_COUNT_TABLE_SCENARIO_FAILED_CELL, rows));
        chartOperations.updateBarChartPlot(TAGS_CHART, categoryRange, valueRanges);
    }

    private void updateTagsFeatureScenarioTableData(CellReference cellRef) {
        TagFeatureScenarioTable.builder().featureAndScenarioTagData(this.reportData.getFeatureAndScenarioTagData()).sheet(this.sheet).startCell(cellRef.formatAsString()).columnCellCount(new int[]{1, 5, 1, 1}).build().writeTableValues();
    }

    protected TagsSheet(TagsSheetBuilder<?, ?> b) {
        super(b);
    }

    public static TagsSheetBuilder<?, ?> builder() {
        return new TagsSheetBuilderImpl();
    }

    private static final class TagsSheetBuilderImpl
    extends TagsSheetBuilder<TagsSheet, TagsSheetBuilderImpl> {
        private TagsSheetBuilderImpl() {
        }

        @Override
        protected TagsSheetBuilderImpl self() {
            return this;
        }

        @Override
        public TagsSheet build() {
            return new TagsSheet(this);
        }
    }

    public static abstract class TagsSheetBuilder<C extends TagsSheet, B extends TagsSheetBuilder<C, B>>
    extends Sheet.SheetBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TagsSheet.TagsSheetBuilder(super=" + super.toString() + ")";
        }
    }
}

