/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.List;
import java.util.function.Function;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.cell.CellValueOptions;

public class SimpleTableOperations<T> {
    private XSSFSheet sheet;

    public void writeTableCellValues(String startCell, List<T> tableData, Function<T, List<String>> rowValueTransformer, List<CellValueOptions> valueOptions) {
        CellReference cellRef = new CellReference(startCell);
        int startRow = cellRef.getRow();
        int endRow = startRow + tableData.size();
        short startColumn = cellRef.getCol();
        int endColumn = startColumn + valueOptions.size();
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        cellOperations.createCellsWithStyleInRange(startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i < endRow; ++i) {
            List<String> rowValue = rowValueTransformer.apply(tableData.get(i - startRow));
            int startCol = cellRef.getCol();
            for (int j = 0; j < rowValue.size(); ++j) {
                cellOperations.writeValue(new CellReference(i, startCol), rowValue.get(j), valueOptions.get(j));
                ++startCol;
            }
        }
    }

    SimpleTableOperations(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public static <T> SimpleTableOperationsBuilder<T> builder() {
        return new SimpleTableOperationsBuilder();
    }

    public static class SimpleTableOperationsBuilder<T> {
        private XSSFSheet sheet;

        SimpleTableOperationsBuilder() {
        }

        public SimpleTableOperationsBuilder<T> sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public SimpleTableOperations<T> build() {
            return new SimpleTableOperations(this.sheet);
        }

        public String toString() {
            return "SimpleTableOperations.SimpleTableOperationsBuilder(sheet=" + this.sheet + ")";
        }
    }
}

