/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.pojo;

import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.excel.report.exception.ExcelReportException;
import tech.grasshopper.extent.data.pojo.Executable;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Hook;
import tech.grasshopper.extent.data.pojo.NonExecutable;
import tech.grasshopper.extent.data.pojo.Step;

public class Scenario
extends NonExecutable {
    private Feature feature;
    private List<Hook> before;
    private List<Step> steps;
    private List<Hook> after;
    private List<String> tags;
    private long passedSteps;
    private long failedSteps;
    private long skippedSteps;
    private long totalSteps;
    private List<Executable> stackTraceExecutables;

    public List<Hook> getBeforeAfterHooks() {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        hooks.addAll(this.before);
        hooks.addAll(this.after);
        return hooks;
    }

    public List<Executable> getStepsAndHooks() {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        this.before.forEach(h -> executables.add((Executable)h));
        this.steps.forEach(s -> {
            s.getBefore().forEach(h -> executables.add((Executable)h));
            executables.add((Executable)s);
            s.getAfter().forEach(h -> executables.add((Executable)h));
        });
        this.after.forEach(h -> executables.add((Executable)h));
        return executables;
    }

    @Override
    public void checkData() {
        if (this.name == null || this.name.isEmpty()) {
            throw new ExcelReportException("Scenario name is null or empty.");
        }
        if (this.feature == null) {
            throw new ExcelReportException("No feature present for scenario - " + this.getName());
        }
        if (this.steps == null || this.steps.isEmpty()) {
            throw new ExcelReportException("No steps present for scenario - " + this.getName());
        }
        if (this.status == null) {
            throw new ExcelReportException("No status present for scenario - " + this.getName());
        }
        super.checkData();
    }

    private static List<Hook> $default$before() {
        return new ArrayList<Hook>();
    }

    private static List<Step> $default$steps() {
        return new ArrayList<Step>();
    }

    private static List<Hook> $default$after() {
        return new ArrayList<Hook>();
    }

    private static List<String> $default$tags() {
        return new ArrayList<String>();
    }

    private static long $default$passedSteps() {
        return 0L;
    }

    private static long $default$failedSteps() {
        return 0L;
    }

    private static long $default$skippedSteps() {
        return 0L;
    }

    private static long $default$totalSteps() {
        return 0L;
    }

    private static List<Executable> $default$stackTraceExecutables() {
        return new ArrayList<Executable>();
    }

    protected Scenario(ScenarioBuilder<?, ?> b) {
        super((NonExecutable.NonExecutableBuilder<?, ?>)b);
        this.feature = ((ScenarioBuilder)b).feature;
        this.before = ((ScenarioBuilder)b).before$set ? ((ScenarioBuilder)b).before$value : Scenario.$default$before();
        this.steps = ((ScenarioBuilder)b).steps$set ? ((ScenarioBuilder)b).steps$value : Scenario.$default$steps();
        this.after = ((ScenarioBuilder)b).after$set ? ((ScenarioBuilder)b).after$value : Scenario.$default$after();
        this.tags = ((ScenarioBuilder)b).tags$set ? ((ScenarioBuilder)b).tags$value : Scenario.$default$tags();
        this.passedSteps = ((ScenarioBuilder)b).passedSteps$set ? ((ScenarioBuilder)b).passedSteps$value : Scenario.$default$passedSteps();
        this.failedSteps = ((ScenarioBuilder)b).failedSteps$set ? ((ScenarioBuilder)b).failedSteps$value : Scenario.$default$failedSteps();
        this.skippedSteps = ((ScenarioBuilder)b).skippedSteps$set ? ((ScenarioBuilder)b).skippedSteps$value : Scenario.$default$skippedSteps();
        this.totalSteps = ((ScenarioBuilder)b).totalSteps$set ? ((ScenarioBuilder)b).totalSteps$value : Scenario.$default$totalSteps();
        this.stackTraceExecutables = ((ScenarioBuilder)b).stackTraceExecutables$set ? ((ScenarioBuilder)b).stackTraceExecutables$value : Scenario.$default$stackTraceExecutables();
    }

    public static ScenarioBuilder<?, ?> builder() {
        return new ScenarioBuilderImpl();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public long getPassedSteps() {
        return this.passedSteps;
    }

    public long getFailedSteps() {
        return this.failedSteps;
    }

    public long getSkippedSteps() {
        return this.skippedSteps;
    }

    public long getTotalSteps() {
        return this.totalSteps;
    }

    public List<Executable> getStackTraceExecutables() {
        return this.stackTraceExecutables;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public void setBefore(List<Hook> before) {
        this.before = before;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public void setAfter(List<Hook> after) {
        this.after = after;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setPassedSteps(long passedSteps) {
        this.passedSteps = passedSteps;
    }

    public void setFailedSteps(long failedSteps) {
        this.failedSteps = failedSteps;
    }

    public void setSkippedSteps(long skippedSteps) {
        this.skippedSteps = skippedSteps;
    }

    public void setTotalSteps(long totalSteps) {
        this.totalSteps = totalSteps;
    }

    public void setStackTraceExecutables(List<Executable> stackTraceExecutables) {
        this.stackTraceExecutables = stackTraceExecutables;
    }

    @Override
    public String toString() {
        return "Scenario(feature=" + this.getFeature() + ", before=" + this.getBefore() + ", steps=" + this.getSteps() + ", after=" + this.getAfter() + ", tags=" + this.getTags() + ", passedSteps=" + this.getPassedSteps() + ", failedSteps=" + this.getFailedSteps() + ", skippedSteps=" + this.getSkippedSteps() + ", totalSteps=" + this.getTotalSteps() + ", stackTraceExecutables=" + this.getStackTraceExecutables() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPassedSteps() != other.getPassedSteps()) {
            return false;
        }
        if (this.getFailedSteps() != other.getFailedSteps()) {
            return false;
        }
        if (this.getSkippedSteps() != other.getSkippedSteps()) {
            return false;
        }
        if (this.getTotalSteps() != other.getTotalSteps()) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        List<Hook> this$before = this.getBefore();
        List<Hook> other$before = other.getBefore();
        if (this$before == null ? other$before != null : !((Object)this$before).equals(other$before)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        List<Hook> this$after = this.getAfter();
        List<Hook> other$after = other.getAfter();
        if (this$after == null ? other$after != null : !((Object)this$after).equals(other$after)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Executable> this$stackTraceExecutables = this.getStackTraceExecutables();
        List<Executable> other$stackTraceExecutables = other.getStackTraceExecutables();
        return !(this$stackTraceExecutables == null ? other$stackTraceExecutables != null : !((Object)this$stackTraceExecutables).equals(other$stackTraceExecutables));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $passedSteps = this.getPassedSteps();
        result = result * 59 + (int)($passedSteps >>> 32 ^ $passedSteps);
        long $failedSteps = this.getFailedSteps();
        result = result * 59 + (int)($failedSteps >>> 32 ^ $failedSteps);
        long $skippedSteps = this.getSkippedSteps();
        result = result * 59 + (int)($skippedSteps >>> 32 ^ $skippedSteps);
        long $totalSteps = this.getTotalSteps();
        result = result * 59 + (int)($totalSteps >>> 32 ^ $totalSteps);
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        List<Hook> $before = this.getBefore();
        result = result * 59 + ($before == null ? 43 : ((Object)$before).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        List<Hook> $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : ((Object)$after).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Executable> $stackTraceExecutables = this.getStackTraceExecutables();
        result = result * 59 + ($stackTraceExecutables == null ? 43 : ((Object)$stackTraceExecutables).hashCode());
        return result;
    }

    private static final class ScenarioBuilderImpl
    extends ScenarioBuilder<Scenario, ScenarioBuilderImpl> {
        private ScenarioBuilderImpl() {
        }

        @Override
        protected ScenarioBuilderImpl self() {
            return this;
        }

        @Override
        public Scenario build() {
            return new Scenario(this);
        }
    }

    public static abstract class ScenarioBuilder<C extends Scenario, B extends ScenarioBuilder<C, B>>
    extends NonExecutable.NonExecutableBuilder<C, B> {
        private Feature feature;
        private boolean before$set;
        private List<Hook> before$value;
        private boolean steps$set;
        private List<Step> steps$value;
        private boolean after$set;
        private List<Hook> after$value;
        private boolean tags$set;
        private List<String> tags$value;
        private boolean passedSteps$set;
        private long passedSteps$value;
        private boolean failedSteps$set;
        private long failedSteps$value;
        private boolean skippedSteps$set;
        private long skippedSteps$value;
        private boolean totalSteps$set;
        private long totalSteps$value;
        private boolean stackTraceExecutables$set;
        private List<Executable> stackTraceExecutables$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B feature(Feature feature) {
            this.feature = feature;
            return (B)this.self();
        }

        public B before(List<Hook> before) {
            this.before$value = before;
            this.before$set = true;
            return (B)this.self();
        }

        public B steps(List<Step> steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B after(List<Hook> after) {
            this.after$value = after;
            this.after$set = true;
            return (B)this.self();
        }

        @Override
        public B tags(List<String> tags) {
            this.tags$value = tags;
            this.tags$set = true;
            return (B)this.self();
        }

        public B passedSteps(long passedSteps) {
            this.passedSteps$value = passedSteps;
            this.passedSteps$set = true;
            return (B)this.self();
        }

        public B failedSteps(long failedSteps) {
            this.failedSteps$value = failedSteps;
            this.failedSteps$set = true;
            return (B)this.self();
        }

        public B skippedSteps(long skippedSteps) {
            this.skippedSteps$value = skippedSteps;
            this.skippedSteps$set = true;
            return (B)this.self();
        }

        public B totalSteps(long totalSteps) {
            this.totalSteps$value = totalSteps;
            this.totalSteps$set = true;
            return (B)this.self();
        }

        public B stackTraceExecutables(List<Executable> stackTraceExecutables) {
            this.stackTraceExecutables$value = stackTraceExecutables;
            this.stackTraceExecutables$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Scenario.ScenarioBuilder(super=" + super.toString() + ", feature=" + this.feature + ", before$value=" + this.before$value + ", steps$value=" + this.steps$value + ", after$value=" + this.after$value + ", tags$value=" + this.tags$value + ", passedSteps$value=" + this.passedSteps$value + ", failedSteps$value=" + this.failedSteps$value + ", skippedSteps$value=" + this.skippedSteps$value + ", totalSteps$value=" + this.totalSteps$value + ", stackTraceExecutables$value=" + this.stackTraceExecutables$value + ")";
        }
    }
}

