/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.model.ReportStats;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import tech.grasshopper.excel.report.util.DateUtil;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class DashboardDataPopulator {
    private List<Feature> features;

    public SheetData.BasicDashboardData populateDashboardData(Report report) {
        ReportStats stats = report.getStats();
        LocalDateTime startTime = DateUtil.convertToLocalDateTimeFromDate(report.getStartTime());
        LocalDateTime endTime = DateUtil.convertToLocalDateTimeFromDate(report.getEndTime());
        SheetData.TimingData timingData = SheetData.TimingData.builder().startTime(startTime).endTime(endTime).duration(Duration.between(startTime, endTime)).build();
        SheetData.BasicDashboardData dashboardData = SheetData.BasicDashboardData.builder().timingData(timingData).featureCounts(this.createCountData(stats.getParent())).scenarioCounts(this.createCountData(stats.getChild())).build();
        SheetData.CountData stepCounts = SheetData.CountData.builder().build();
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                stepCounts.setPassed(stepCounts.getPassed() + scenario.getPassedSteps());
                stepCounts.setFailed(stepCounts.getFailed() + scenario.getFailedSteps());
                stepCounts.setSkipped(stepCounts.getSkipped() + scenario.getSkippedSteps());
                stepCounts.setTotal(stepCounts.getTotal() + scenario.getTotalSteps());
            }
        }
        dashboardData.setStepCounts(stepCounts);
        return dashboardData;
    }

    private SheetData.CountData createCountData(Map<Status, Long> statusCounts) {
        Long total = statusCounts.getOrDefault(Status.PASS, 0L) + statusCounts.getOrDefault(Status.FAIL, 0L) + statusCounts.getOrDefault(Status.SKIP, 0L);
        return SheetData.CountData.builder().total(total).passed(statusCounts.getOrDefault(Status.PASS, 0L)).failed(statusCounts.getOrDefault(Status.FAIL, 0L)).skipped(statusCounts.getOrDefault(Status.SKIP, 0L)).build();
    }

    DashboardDataPopulator(List<Feature> features) {
        this.features = features;
    }

    public static DashboardDataPopulatorBuilder builder() {
        return new DashboardDataPopulatorBuilder();
    }

    public static class DashboardDataPopulatorBuilder {
        private List<Feature> features;

        DashboardDataPopulatorBuilder() {
        }

        public DashboardDataPopulatorBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public DashboardDataPopulator build() {
            return new DashboardDataPopulator(this.features);
        }

        public String toString() {
            return "DashboardDataPopulator.DashboardDataPopulatorBuilder(features=" + this.features + ")";
        }
    }
}

