/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.util.List;
import tech.grasshopper.extent.data.pojo.Executable;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Hook;
import tech.grasshopper.extent.data.pojo.NonExecutable;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;
import tech.grasshopper.extent.data.pojo.Step;

public class ExceptionDataPopulator {
    private List<Feature> features;

    public void populateExceptionData(List<Feature> data) {
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) continue;
            NonExecutable feat = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(feature.getName())).status(feature.getStatus())).build();
            for (Scenario scenario : feature.getScenarios()) {
                if (scenario.getStatus() == Status.PASSED) continue;
                NonExecutable scen = ((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)Scenario.builder().name(scenario.getName())).status(scenario.getStatus())).build();
                boolean presentStackExec = false;
                for (Executable executable : scenario.getStepsAndHooks()) {
                    if (executable.getStatus() == Status.PASSED || executable.getStatus() == Status.SKIPPED && executable.getErrorMessage().isEmpty()) continue;
                    presentStackExec = true;
                    if (executable.getExecutableType() == Executable.ExecutableType.STEP) {
                        ((Scenario)scen).getStackTraceExecutables().add(((Step.StepBuilder)((Step.StepBuilder)((Step.StepBuilder)((Step.StepBuilder)Step.builder().name(executable.getName())).executableType(Executable.ExecutableType.STEP)).status(executable.getStatus())).errorMessage(executable.getErrorMessage())).build());
                    } else if (executable.getExecutableType() == Executable.ExecutableType.HOOK) {
                        ((Scenario)scen).getStackTraceExecutables().add(((Hook.HookBuilder)((Hook.HookBuilder)((Hook.HookBuilder)((Hook.HookBuilder)((Hook.HookBuilder)Hook.builder().name(executable.getName())).location(executable.getLocation())).executableType(Executable.ExecutableType.HOOK)).status(executable.getStatus())).errorMessage(executable.getErrorMessage())).build());
                    }
                    ((Feature)feat).setTotalSteps(((Feature)feat).getTotalSteps() + 1L);
                    ((Scenario)scen).setTotalSteps(((Scenario)scen).getTotalSteps() + 1L);
                }
                if (!presentStackExec) continue;
                ((Feature)feat).getScenarios().add((Scenario)scen);
                ((Feature)feat).setTotalScenarios(((Feature)feat).getTotalScenarios() + 1L);
            }
            if (((Feature)feat).getScenarios().isEmpty()) continue;
            data.add((Feature)feat);
        }
    }

    ExceptionDataPopulator(List<Feature> features) {
        this.features = features;
    }

    public static ExceptionDataPopulatorBuilder builder() {
        return new ExceptionDataPopulatorBuilder();
    }

    public static class ExceptionDataPopulatorBuilder {
        private List<Feature> features;

        ExceptionDataPopulatorBuilder() {
        }

        public ExceptionDataPopulatorBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ExceptionDataPopulator build() {
            return new ExceptionDataPopulator(this.features);
        }

        public String toString() {
            return "ExceptionDataPopulator.ExceptionDataPopulatorBuilder(features=" + this.features + ")";
        }
    }
}

