/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.chart;

import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.exception.ExcelReportException;

public class ChartOperations {
    private XSSFSheet chartSheet;
    private XSSFSheet dataSheet;

    public void updateBarChartPlot(String chartTitle, ChartDataSeriesRange categoryRange, List<ChartDataSeriesRange> valueRanges) {
        XSSFChart chart = this.retrieveChartFromSheetByTitle(chartTitle);
        List data = chart.getChartSeries();
        XDDFCategoryDataSource category = XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)this.dataSheet, (CellRangeAddress)categoryRange.convertToCellRange());
        for (int i = 0; i < valueRanges.size(); ++i) {
            XDDFNumericalDataSource value = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)this.dataSheet, (CellRangeAddress)valueRanges.get(i).convertToCellRange());
            ((XDDFChartData)data.get(0)).getSeries(i).replaceData((XDDFDataSource)category, value);
        }
        chart.plot((XDDFChartData)data.get(0));
    }

    private XSSFChart retrieveChartFromSheetByTitle(String chartTitle) {
        return this.chartSheet.getDrawingPatriarch().getCharts().stream().filter(c -> c.getTitleText().getString().trim().equals(chartTitle)).findFirst().orElseThrow(() -> new ExcelReportException("Chart with title '" + chartTitle + "' not present in sheet."));
    }

    ChartOperations(XSSFSheet chartSheet, XSSFSheet dataSheet) {
        this.chartSheet = chartSheet;
        this.dataSheet = dataSheet;
    }

    public static ChartOperationsBuilder builder() {
        return new ChartOperationsBuilder();
    }

    public static class ChartOperationsBuilder {
        private XSSFSheet chartSheet;
        private XSSFSheet dataSheet;

        ChartOperationsBuilder() {
        }

        public ChartOperationsBuilder chartSheet(XSSFSheet chartSheet) {
            this.chartSheet = chartSheet;
            return this;
        }

        public ChartOperationsBuilder dataSheet(XSSFSheet dataSheet) {
            this.dataSheet = dataSheet;
            return this;
        }

        public ChartOperations build() {
            return new ChartOperations(this.chartSheet, this.dataSheet);
        }

        public String toString() {
            return "ChartOperations.ChartOperationsBuilder(chartSheet=" + this.chartSheet + ", dataSheet=" + this.dataSheet + ")";
        }
    }

    public static class ChartDataSeriesRange {
        private int firstRow;
        private int lastRow;
        private int firstColumn;
        private int lastColumn;

        public CellRangeAddress convertToCellRange() {
            return new CellRangeAddress(this.firstRow, this.lastRow, this.firstColumn, this.lastColumn);
        }

        public static ChartDataSeriesRange convertCellReferenceToChartDataRange(String cellStr, int rows) {
            CellReference cellRef = new CellReference(cellStr);
            return ChartDataSeriesRange.builder().firstRow(cellRef.getRow()).lastRow(cellRef.getRow() + (rows - 1)).firstColumn(cellRef.getCol()).lastColumn(cellRef.getCol()).build();
        }

        ChartDataSeriesRange(int firstRow, int lastRow, int firstColumn, int lastColumn) {
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.firstColumn = firstColumn;
            this.lastColumn = lastColumn;
        }

        public static ChartDataSeriesRangeBuilder builder() {
            return new ChartDataSeriesRangeBuilder();
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        public int getLastRow() {
            return this.lastRow;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }

        public void setFirstRow(int firstRow) {
            this.firstRow = firstRow;
        }

        public void setLastRow(int lastRow) {
            this.lastRow = lastRow;
        }

        public void setFirstColumn(int firstColumn) {
            this.firstColumn = firstColumn;
        }

        public void setLastColumn(int lastColumn) {
            this.lastColumn = lastColumn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChartDataSeriesRange)) {
                return false;
            }
            ChartDataSeriesRange other = (ChartDataSeriesRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFirstRow() != other.getFirstRow()) {
                return false;
            }
            if (this.getLastRow() != other.getLastRow()) {
                return false;
            }
            if (this.getFirstColumn() != other.getFirstColumn()) {
                return false;
            }
            return this.getLastColumn() == other.getLastColumn();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChartDataSeriesRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstRow();
            result = result * 59 + this.getLastRow();
            result = result * 59 + this.getFirstColumn();
            result = result * 59 + this.getLastColumn();
            return result;
        }

        public String toString() {
            return "ChartOperations.ChartDataSeriesRange(firstRow=" + this.getFirstRow() + ", lastRow=" + this.getLastRow() + ", firstColumn=" + this.getFirstColumn() + ", lastColumn=" + this.getLastColumn() + ")";
        }

        public static class ChartDataSeriesRangeBuilder {
            private int firstRow;
            private int lastRow;
            private int firstColumn;
            private int lastColumn;

            ChartDataSeriesRangeBuilder() {
            }

            public ChartDataSeriesRangeBuilder firstRow(int firstRow) {
                this.firstRow = firstRow;
                return this;
            }

            public ChartDataSeriesRangeBuilder lastRow(int lastRow) {
                this.lastRow = lastRow;
                return this;
            }

            public ChartDataSeriesRangeBuilder firstColumn(int firstColumn) {
                this.firstColumn = firstColumn;
                return this;
            }

            public ChartDataSeriesRangeBuilder lastColumn(int lastColumn) {
                this.lastColumn = lastColumn;
                return this;
            }

            public ChartDataSeriesRange build() {
                return new ChartDataSeriesRange(this.firstRow, this.lastRow, this.firstColumn, this.lastColumn);
            }

            public String toString() {
                return "ChartOperations.ChartDataSeriesRange.ChartDataSeriesRangeBuilder(firstRow=" + this.firstRow + ", lastRow=" + this.lastRow + ", firstColumn=" + this.firstColumn + ", lastColumn=" + this.lastColumn + ")";
            }
        }
    }
}

