/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.table;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellOperations;
import tech.grasshopper.excel.report.cell.CellStyles;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class FeatureScenarioFailSkipTable {
    private XSSFSheet sheet;
    private String startCell;
    private List<Feature> failSkipFeatureAndScenarioData;
    private final int[] columnCellCount = new int[]{2, 1, 2, 1};
    private boolean groupRows;

    public void writeTableValues() {
        CellOperations cellOperations = CellOperations.builder().sheet(this.sheet).build();
        CellReference cellRef = new CellReference(this.startCell);
        int startRow = cellRef.getRow();
        int startCol = cellRef.getCol();
        int rowCount = (int)this.failSkipFeatureAndScenarioData.stream().mapToLong(f -> f.getTotalScenarios()).sum();
        cellOperations.createCellsWithStyleInRange(startRow, startRow + rowCount, startCol, startCol + Arrays.stream(this.columnCellCount).sum());
        int currentRow = startRow;
        for (Feature feature : this.failSkipFeatureAndScenarioData) {
            int currentCol = startCol;
            cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol, this.columnCellCount[0]);
            cellOperations.writeValue(new CellReference(currentRow, currentCol), feature.getName(), CellStyles.getStatusColorStyle(feature.getStatus()), ValueOption.STATUS_COLOR);
            cellOperations.mergeRows(currentRow, (int)feature.getTotalScenarios(), currentCol += this.columnCellCount[0], this.columnCellCount[1]);
            cellOperations.writeValue(new CellReference(currentRow, currentCol), feature.getStatus().toString(), "STATUS_TEXT_BOLD_CELL_STYLE", ValueOption.STATUS_TEXT);
            currentCol += this.columnCellCount[1];
            for (Scenario scenario : feature.getScenarios()) {
                cellOperations.mergeRows(currentRow, 1, currentCol, this.columnCellCount[2]);
                cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getName(), CellStyles.getStatusColorStyle(scenario.getStatus()), ValueOption.STATUS_COLOR);
                cellOperations.mergeRows(currentRow, 1, currentCol += this.columnCellCount[2], this.columnCellCount[3]);
                cellOperations.writeValue(new CellReference(currentRow, currentCol), scenario.getStatus().toString(), "STATUS_TEXT_BOLD_CELL_STYLE", ValueOption.STATUS_TEXT);
                currentCol -= this.columnCellCount[2];
                ++currentRow;
            }
        }
        if (this.groupRows) {
            this.sheet.groupRow(startRow, startRow + rowCount - 1);
            this.sheet.setRowGroupCollapsed(startRow, true);
        }
    }

    private static boolean $default$groupRows() {
        return false;
    }

    FeatureScenarioFailSkipTable(XSSFSheet sheet, String startCell, List<Feature> failSkipFeatureAndScenarioData, boolean groupRows) {
        this.sheet = sheet;
        this.startCell = startCell;
        this.failSkipFeatureAndScenarioData = failSkipFeatureAndScenarioData;
        this.groupRows = groupRows;
    }

    public static FeatureScenarioFailSkipTableBuilder builder() {
        return new FeatureScenarioFailSkipTableBuilder();
    }

    public static class FeatureScenarioFailSkipTableBuilder {
        private XSSFSheet sheet;
        private String startCell;
        private List<Feature> failSkipFeatureAndScenarioData;
        private boolean groupRows$set;
        private boolean groupRows$value;

        FeatureScenarioFailSkipTableBuilder() {
        }

        public FeatureScenarioFailSkipTableBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public FeatureScenarioFailSkipTableBuilder startCell(String startCell) {
            this.startCell = startCell;
            return this;
        }

        public FeatureScenarioFailSkipTableBuilder failSkipFeatureAndScenarioData(List<Feature> failSkipFeatureAndScenarioData) {
            this.failSkipFeatureAndScenarioData = failSkipFeatureAndScenarioData;
            return this;
        }

        public FeatureScenarioFailSkipTableBuilder groupRows(boolean groupRows) {
            this.groupRows$value = groupRows;
            this.groupRows$set = true;
            return this;
        }

        public FeatureScenarioFailSkipTable build() {
            boolean groupRows$value = this.groupRows$value;
            if (!this.groupRows$set) {
                groupRows$value = FeatureScenarioFailSkipTable.$default$groupRows();
            }
            return new FeatureScenarioFailSkipTable(this.sheet, this.startCell, this.failSkipFeatureAndScenarioData, groupRows$value);
        }

        public String toString() {
            return "FeatureScenarioFailSkipTable.FeatureScenarioFailSkipTableBuilder(sheet=" + this.sheet + ", startCell=" + this.startCell + ", failSkipFeatureAndScenarioData=" + this.failSkipFeatureAndScenarioData + ", groupRows$value=" + this.groupRows$value + ")";
        }
    }
}

