/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data;

import com.aventstack.extentreports.model.Report;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tech.grasshopper.excel.report.exception.ExcelReportException;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.generator.AttributeDataPopulator;
import tech.grasshopper.extent.data.generator.DashboardDataPopulator;
import tech.grasshopper.extent.data.generator.ExceptionDataPopulator;
import tech.grasshopper.extent.data.generator.FailSkipDataPopulator;
import tech.grasshopper.extent.data.generator.HeirarchyDataPopulator;
import tech.grasshopper.extent.data.generator.NonExecutableDataPopulator;
import tech.grasshopper.extent.data.generator.ReportDataHeirarchy;
import tech.grasshopper.extent.data.generator.TagDataPopulator;
import tech.grasshopper.extent.data.pojo.Executable;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class ReportData {
    private List<Feature> features;
    private SheetData.BasicDashboardData dashboardData;
    private List<SheetData.AttributeCountData> failSkipTagCountData = new ArrayList<SheetData.AttributeCountData>();
    private Map<String, List<Feature>> failSkipFeatureAndScenarioTagData = new LinkedHashMap<String, List<Feature>>();
    private List<Feature> failSkipFeatureAndScenarioData = new ArrayList<Feature>();
    private List<SheetData.AttributeCountData> tagData = new ArrayList<SheetData.AttributeCountData>();
    private Map<String, List<Feature>> featureAndScenarioTagData = new LinkedHashMap<String, List<Feature>>();
    private List<SheetData.AttributeCountData> authorData = new ArrayList<SheetData.AttributeCountData>();
    private Map<String, List<Feature>> featureAndScenarioAuthorData = new LinkedHashMap<String, List<Feature>>();
    private List<SheetData.AttributeCountData> deviceData = new ArrayList<SheetData.AttributeCountData>();
    private Map<String, List<Feature>> featureAndScenarioDeviceData = new LinkedHashMap<String, List<Feature>>();
    private List<SheetData.FeatureData> featureData = new ArrayList<SheetData.FeatureData>();
    private List<SheetData.ScenarioData> scenarioData = new ArrayList<SheetData.ScenarioData>();
    private List<Feature> exceptionData = new ArrayList<Feature>();

    public void createData(Report report) {
        this.features = ReportDataHeirarchy.builder().report(report).build().createFeatureHeirarchy();
        this.populateCounts();
        this.checkData();
        this.populateDashboardData(report);
        this.populateFailSkipTagCountData();
        this.populateFailSkipFeatureAndScenarioTagData();
        this.populateFailSkipFeatureAndScenarioData();
        this.populateTagData();
        this.populateFeatureAndScenarioTagData();
        this.populateAuthorData();
        this.populateFeatureAndScenarioAuthorData();
        this.populateDeviceData();
        this.populateFeatureAndScenarioDeviceData();
        this.populateFeatureData();
        this.populateScenarioData();
        this.populateExceptionData();
    }

    private void checkData() {
        if (this.features == null || this.features.size() == 0) {
            throw new ExcelReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            feature.checkData();
            for (Scenario scenario : feature.getScenarios()) {
                scenario.checkData();
                for (Executable executable : scenario.getStepsAndHooks()) {
                    executable.checkData();
                }
            }
        }
    }

    private void populateCounts() {
        HeirarchyDataPopulator.builder().features(this.features).build().populateCountsAndParentDetails();
    }

    private void populateDashboardData(Report report) {
        this.dashboardData = DashboardDataPopulator.builder().features(this.features).build().populateDashboardData(report);
    }

    private void populateFailSkipTagCountData() {
        ((TagDataPopulator)((TagDataPopulator.TagDataPopulatorBuilder)TagDataPopulator.builder().features(this.features)).build()).populateFailAndSkipScenariosTagCountData(this.failSkipTagCountData);
    }

    private void populateFailSkipFeatureAndScenarioTagData() {
        ((TagDataPopulator)((TagDataPopulator.TagDataPopulatorBuilder)TagDataPopulator.builder().features(this.features)).build()).populateFailSkipFeatureScenarioData(this.failSkipFeatureAndScenarioTagData);
    }

    private void populateFailSkipFeatureAndScenarioData() {
        FailSkipDataPopulator.builder().features(this.features).build().populateFailSkipFeatureScenarioData(this.failSkipFeatureAndScenarioData);
    }

    private void populateTagData() {
        ((TagDataPopulator.TagDataPopulatorBuilder)TagDataPopulator.builder().features(this.features)).build().populateAttributeCountData(this.tagData);
    }

    private void populateFeatureAndScenarioTagData() {
        ((TagDataPopulator.TagDataPopulatorBuilder)TagDataPopulator.builder().features(this.features)).build().populateAttributeFeatureScenarioData(this.featureAndScenarioTagData);
    }

    private void populateAuthorData() {
        ((AttributeDataPopulator.AuthorDataPopulator.AuthorDataPopulatorBuilder)AttributeDataPopulator.AuthorDataPopulator.builder().features(this.features)).build().populateAttributeCountData(this.authorData);
    }

    private void populateFeatureAndScenarioAuthorData() {
        ((AttributeDataPopulator.AuthorDataPopulator.AuthorDataPopulatorBuilder)AttributeDataPopulator.AuthorDataPopulator.builder().features(this.features)).build().populateAttributeFeatureScenarioData(this.featureAndScenarioAuthorData);
    }

    private void populateDeviceData() {
        ((AttributeDataPopulator.DeviceDataPopulator.DeviceDataPopulatorBuilder)AttributeDataPopulator.DeviceDataPopulator.builder().features(this.features)).build().populateAttributeCountData(this.deviceData);
    }

    private void populateFeatureAndScenarioDeviceData() {
        ((AttributeDataPopulator.DeviceDataPopulator.DeviceDataPopulatorBuilder)AttributeDataPopulator.DeviceDataPopulator.builder().features(this.features)).build().populateAttributeFeatureScenarioData(this.featureAndScenarioDeviceData);
    }

    private void populateFeatureData() {
        NonExecutableDataPopulator.builder().features(this.features).build().populateFeatureData(this.featureData);
    }

    private void populateScenarioData() {
        NonExecutableDataPopulator.builder().features(this.features).build().populateScenarioData(this.scenarioData);
    }

    private void populateExceptionData() {
        ExceptionDataPopulator.builder().features(this.features).build().populateExceptionData(this.exceptionData);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public SheetData.BasicDashboardData getDashboardData() {
        return this.dashboardData;
    }

    public List<SheetData.AttributeCountData> getFailSkipTagCountData() {
        return this.failSkipTagCountData;
    }

    public Map<String, List<Feature>> getFailSkipFeatureAndScenarioTagData() {
        return this.failSkipFeatureAndScenarioTagData;
    }

    public List<Feature> getFailSkipFeatureAndScenarioData() {
        return this.failSkipFeatureAndScenarioData;
    }

    public List<SheetData.AttributeCountData> getTagData() {
        return this.tagData;
    }

    public Map<String, List<Feature>> getFeatureAndScenarioTagData() {
        return this.featureAndScenarioTagData;
    }

    public List<SheetData.AttributeCountData> getAuthorData() {
        return this.authorData;
    }

    public Map<String, List<Feature>> getFeatureAndScenarioAuthorData() {
        return this.featureAndScenarioAuthorData;
    }

    public List<SheetData.AttributeCountData> getDeviceData() {
        return this.deviceData;
    }

    public Map<String, List<Feature>> getFeatureAndScenarioDeviceData() {
        return this.featureAndScenarioDeviceData;
    }

    public List<SheetData.FeatureData> getFeatureData() {
        return this.featureData;
    }

    public List<SheetData.ScenarioData> getScenarioData() {
        return this.scenarioData;
    }

    public List<Feature> getExceptionData() {
        return this.exceptionData;
    }
}

