/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.NonExecutable;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;

public abstract class AttributeDataPopulator {
    protected List<Feature> features;

    protected abstract List<String> getAttributeNames(Scenario var1);

    public void populateAttributeCountData(List<SheetData.AttributeCountData> attributeData) {
        this.populateAttributeCountData(attributeData, this.features);
    }

    protected void populateAttributeCountData(List<SheetData.AttributeCountData> attributeData, List<Feature> statusFilteredFeatures) {
        HashMap<String, SheetData.AttributeCountData> attributeDatas = new HashMap<String, SheetData.AttributeCountData>();
        for (Feature feature : statusFilteredFeatures) {
            for (Scenario scenario : feature.getScenarios()) {
                List<String> attributes = this.getAttributeNames(scenario);
                for (String attribute : attributes) {
                    SheetData.AttributeCountData acd = attributeDatas.computeIfAbsent(attribute, k -> SheetData.AttributeCountData.builder().name(attribute).scenarioCounts(SheetData.CountData.builder().build()).build());
                    if (!attributeData.stream().anyMatch(a -> acd.getName().equals(a.getName()))) {
                        attributeData.add(acd);
                    }
                    SheetData.CountData scenarioCounts = acd.getScenarioCounts();
                    scenarioCounts.setTotal(scenarioCounts.getTotal() + 1L);
                    if (scenario.getStatus() == Status.PASSED) {
                        scenarioCounts.setPassed(scenarioCounts.getPassed() + 1L);
                        continue;
                    }
                    if (scenario.getStatus() == Status.FAILED) {
                        scenarioCounts.setFailed(scenarioCounts.getFailed() + 1L);
                        continue;
                    }
                    if (scenario.getStatus() != Status.SKIPPED) continue;
                    scenarioCounts.setSkipped(scenarioCounts.getSkipped() + 1L);
                }
            }
        }
    }

    public void populateAttributeFeatureScenarioData(Map<String, List<Feature>> data) {
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                this.populateAttributeFeatureScenarioData(data, feature, scenario);
            }
        }
    }

    protected void populateAttributeFeatureScenarioData(Map<String, List<Feature>> data, Feature feature, Scenario scenario) {
        for (String attribute : this.getAttributeNames(scenario)) {
            List feats = data.computeIfAbsent(attribute, f -> new ArrayList());
            Feature feat = feats.stream().filter(f -> f.getName().equals(feature.getName())).findAny().orElseGet(() -> {
                NonExecutable f = ((Feature.FeatureBuilder)((Feature.FeatureBuilder)Feature.builder().name(feature.getName())).status(feature.getStatus())).build();
                feats.add(f);
                return f;
            });
            feat.getScenarios().add((Scenario)((Scenario.ScenarioBuilder)((Scenario.ScenarioBuilder)Scenario.builder().name(scenario.getName())).status(scenario.getStatus())).build());
            feat.setTotalScenarios(feat.getTotalScenarios() + 1L);
        }
    }

    protected AttributeDataPopulator(AttributeDataPopulatorBuilder<?, ?> b) {
        this.features = ((AttributeDataPopulatorBuilder)b).features;
    }

    public static abstract class AttributeDataPopulatorBuilder<C extends AttributeDataPopulator, B extends AttributeDataPopulatorBuilder<C, B>> {
        private List<Feature> features;

        protected abstract B self();

        public abstract C build();

        public B features(List<Feature> features) {
            this.features = features;
            return this.self();
        }

        public String toString() {
            return "AttributeDataPopulator.AttributeDataPopulatorBuilder(features=" + this.features + ")";
        }
    }

    public static class DeviceDataPopulator
    extends AttributeDataPopulator {
        @Override
        protected List<String> getAttributeNames(Scenario scenario) {
            return scenario.getDevices();
        }

        protected DeviceDataPopulator(DeviceDataPopulatorBuilder<?, ?> b) {
            super(b);
        }

        public static DeviceDataPopulatorBuilder<?, ?> builder() {
            return new DeviceDataPopulatorBuilderImpl();
        }

        private static final class DeviceDataPopulatorBuilderImpl
        extends DeviceDataPopulatorBuilder<DeviceDataPopulator, DeviceDataPopulatorBuilderImpl> {
            private DeviceDataPopulatorBuilderImpl() {
            }

            @Override
            protected DeviceDataPopulatorBuilderImpl self() {
                return this;
            }

            @Override
            public DeviceDataPopulator build() {
                return new DeviceDataPopulator(this);
            }
        }

        public static abstract class DeviceDataPopulatorBuilder<C extends DeviceDataPopulator, B extends DeviceDataPopulatorBuilder<C, B>>
        extends AttributeDataPopulatorBuilder<C, B> {
            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "AttributeDataPopulator.DeviceDataPopulator.DeviceDataPopulatorBuilder(super=" + super.toString() + ")";
            }
        }
    }

    public static class AuthorDataPopulator
    extends AttributeDataPopulator {
        @Override
        protected List<String> getAttributeNames(Scenario scenario) {
            return scenario.getAuthors();
        }

        protected AuthorDataPopulator(AuthorDataPopulatorBuilder<?, ?> b) {
            super(b);
        }

        public static AuthorDataPopulatorBuilder<?, ?> builder() {
            return new AuthorDataPopulatorBuilderImpl();
        }

        private static final class AuthorDataPopulatorBuilderImpl
        extends AuthorDataPopulatorBuilder<AuthorDataPopulator, AuthorDataPopulatorBuilderImpl> {
            private AuthorDataPopulatorBuilderImpl() {
            }

            @Override
            protected AuthorDataPopulatorBuilderImpl self() {
                return this;
            }

            @Override
            public AuthorDataPopulator build() {
                return new AuthorDataPopulator(this);
            }
        }

        public static abstract class AuthorDataPopulatorBuilder<C extends AuthorDataPopulator, B extends AuthorDataPopulatorBuilder<C, B>>
        extends AttributeDataPopulatorBuilder<C, B> {
            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "AttributeDataPopulator.AuthorDataPopulator.AuthorDataPopulatorBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

