/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import tech.grasshopper.pdf.extent.processor.Processor;

public class DocStringProcessor
extends Processor {
    @Override
    public String process() {
        for (Log log : this.logs) {
            String html;
            Document doc;
            Element element;
            if (log.getStatus() != Status.PASS || (element = (doc = Jsoup.parseBodyFragment((String)(html = log.getDetails()))).selectFirst("body textarea[class*=\"code-block\"]")) == null) continue;
            return element.text();
        }
        return "";
    }

    protected DocStringProcessor(DocStringProcessorBuilder<?, ?> b) {
        super(b);
    }

    public static DocStringProcessorBuilder<?, ?> builder() {
        return new DocStringProcessorBuilderImpl();
    }

    private static final class DocStringProcessorBuilderImpl
    extends DocStringProcessorBuilder<DocStringProcessor, DocStringProcessorBuilderImpl> {
        private DocStringProcessorBuilderImpl() {
        }

        @Override
        protected DocStringProcessorBuilderImpl self() {
            return this;
        }

        @Override
        public DocStringProcessor build() {
            return new DocStringProcessor(this);
        }
    }

    public static abstract class DocStringProcessorBuilder<C extends DocStringProcessor, B extends DocStringProcessorBuilder<C, B>>
    extends Processor.ProcessorBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DocStringProcessor.DocStringProcessorBuilder(super=" + super.toString() + ")";
        }
    }
}

