/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.service;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.ExtentKlovReporter;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.JsonFormatter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import com.aventstack.extentreports.reporter.ReporterFilterable;
import com.aventstack.extentreports.reporter.configuration.ViewName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.extent.ExtentPDFCucumberReporter;
import tech.grasshopper.pdf.section.details.executable.MediaCleanup;
import tech.grasshopper.reporter.ExtentExcelCucumberReporter;

public class ExtentService
implements Serializable {
    private static final long serialVersionUID = -5008231199972325650L;
    private static Properties properties;

    public static synchronized ExtentReports getInstance() {
        return ExtentReportsLoader.INSTANCE;
    }

    public static Object getProperty(String key) {
        String sys = System.getProperty(key);
        return sys == null ? (properties == null ? null : properties.get(key)) : sys;
    }

    public static Object getPropertyOrDefault(String key, Object defaultValue) {
        Object value = ExtentService.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public static String getScreenshotFolderName() {
        return ExtentReportsLoader.SCREENSHOT_FOLDER_NAME;
    }

    public static String getScreenshotReportRelatvePath() {
        return ExtentReportsLoader.SCREENSHOT_FOLDER_REPORT_RELATIVE_PATH;
    }

    public static boolean isBase64ImageSrcEnabled() {
        return ExtentReportsLoader.ENABLE_BASE64_IMAGE_SRC;
    }

    public static boolean isDeviceEnabled() {
        return ExtentReportsLoader.IS_DEVICE_ENABLED;
    }

    public static boolean isAuthorEnabled() {
        return ExtentReportsLoader.IS_AUTHOR_ENABLED;
    }

    public static String getDevicePrefix() {
        return ExtentReportsLoader.DEVICE_NAME_PREFIX;
    }

    public static String getAuthorPrefix() {
        return ExtentReportsLoader.AUTHOR_NAME_PREFIX;
    }

    private ExtentReports readResolve() {
        return ExtentReportsLoader.INSTANCE;
    }

    private static class ExtentReportsLoader {
        private static final ExtentReports INSTANCE = new ExtentReports();
        private static final String[] DEFAULT_SETUP_PATH = new String[]{"extent.properties", "com/aventstack/adapter/extent.properties"};
        private static final String SYS_INFO_MARKER = "systeminfo.";
        private static final String OUTPUT_PATH = "test-output/";
        private static final String EXTENT_REPORTER = "extent.reporter";
        private static final String START = "start";
        private static final String CONFIG = "config";
        private static final String OUT = "out";
        private static final String VIEW_ORDER = "vieworder";
        private static final String STATUS_FILTER = "statusfilter";
        private static final String BASE64_IMAGE_SRC = "base64imagesrc";
        private static final String ENABLE_DEVICE = "enable.device";
        private static final String ENABLE_AUTHOR = "enable.author";
        private static final String PREFIX_DEVICE = "prefix.device";
        private static final String PREFIX_AUTHOR = "prefix.author";
        private static final String DELIM = ".";
        private static final String KLOV = "klov";
        private static final String SPARK = "spark";
        private static final String JSONF = "json";
        private static final String PDF = "pdf";
        private static final String HTML = "html";
        private static final String EXCEL = "excel";
        private static final String INIT_KLOV_KEY = "extent.reporter.klov.start";
        private static final String INIT_SPARK_KEY = "extent.reporter.spark.start";
        private static final String INIT_JSONF_KEY = "extent.reporter.json.start";
        private static final String INIT_PDF_KEY = "extent.reporter.pdf.start";
        private static final String INIT_HTML_KEY = "extent.reporter.html.start";
        private static final String INIT_EXCEL_KEY = "extent.reporter.excel.start";
        private static final String CONFIG_KLOV_KEY = "extent.reporter.klov.config";
        private static final String CONFIG_SPARK_KEY = "extent.reporter.spark.config";
        private static final String CONFIG_HTML_KEY = "extent.reporter.html.config";
        private static final String OUT_SPARK_KEY = "extent.reporter.spark.out";
        private static final String OUT_JSONF_KEY = "extent.reporter.json.out";
        private static final String OUT_PDF_KEY = "extent.reporter.pdf.out";
        private static final String OUT_HTML_KEY = "extent.reporter.html.out";
        private static final String OUT_EXCEL_KEY = "extent.reporter.excel.out";
        private static final String VIEW_ORDER_SPARK_KEY = "extent.reporter.spark.vieworder";
        private static final String BASE64_IMAGE_SRC_SPARK_KEY = "extent.reporter.spark.base64imagesrc";
        private static final String DEVICE_ENABLE_SPARK_KEY = "extent.reporter.spark.enable.device";
        private static final String AUTHOR_ENABLE_SPARK_KEY = "extent.reporter.spark.enable.author";
        private static final String DEVICE_PREFIX_SPARK_KEY = "extent.reporter.spark.prefix.device";
        private static final String AUTHOR_PREFIX_SPARK_KEY = "extent.reporter.spark.prefix.author";
        private static boolean ENABLE_BASE64_IMAGE_SRC = false;
        private static final String STATUS_FILTER_KEY = "extent.reporter.statusfilter";
        private static String SCREENSHOT_FOLDER_NAME;
        private static String SCREENSHOT_FOLDER_REPORT_RELATIVE_PATH;
        private static final String DEFAULT_SCREENSHOT_FOLDER_NAME = "test-output/";
        private static final String SCREENSHOT_DIR_PROPERTY = "screenshot.dir";
        private static final String SCREENSHOT_REL_PATH_PROPERTY = "screenshot.rel.path";
        private static final String REPORTS_BASEFOLDER = "basefolder";
        private static final String REPORTS_BASEFOLDER_NAME = "basefolder.name";
        private static final String REPORTS_BASEFOLDER_DATETIMEPATTERN = "basefolder.datetimepattern";
        private static final String REPORTS_BASEFOLDER_ENABLEDELIMITER = "basefolder.enable.delimiter";
        private static final String REPORTS_BASEFOLDER_DELIMITER = "basefolder.delimiter";
        private static final LocalDateTime FOLDER_CURRENT_TIMESTAMP;
        private static boolean IS_DEVICE_ENABLED;
        private static boolean IS_AUTHOR_ENABLED;
        private static String DEVICE_NAME_PREFIX;
        private static String AUTHOR_NAME_PREFIX;
        private static final String DEFAULT_DEVICE_PREFIX = "@dev_";
        private static final String DEFAULT_AUTHOR_PREFIX = "@aut_";

        private ExtentReportsLoader() {
        }

        private static void createViaProperties() {
            ClassLoader loader = ExtentReportsLoader.class.getClassLoader();
            Optional<InputStream> is = Arrays.stream(DEFAULT_SETUP_PATH).map(x -> loader.getResourceAsStream((String)x)).filter(x -> x != null).findFirst();
            if (is.isPresent()) {
                Properties properties = new Properties();
                try {
                    properties.load(is.get());
                    properties = properties;
                    if (properties.containsKey(INIT_KLOV_KEY) && "true".equals(String.valueOf(properties.get(INIT_KLOV_KEY)))) {
                        ExtentReportsLoader.initKlov(properties);
                    }
                    if (properties.containsKey(INIT_SPARK_KEY) && "true".equals(String.valueOf(properties.get(INIT_SPARK_KEY)))) {
                        ExtentReportsLoader.initSpark(properties);
                    }
                    if (properties.containsKey(INIT_JSONF_KEY) && "true".equals(String.valueOf(properties.get(INIT_JSONF_KEY)))) {
                        ExtentReportsLoader.initJsonf(properties);
                    }
                    if (properties.containsKey(INIT_PDF_KEY) && "true".equals(String.valueOf(properties.get(INIT_PDF_KEY)))) {
                        ExtentReportsLoader.initPdf(properties);
                    }
                    if (properties.containsKey(INIT_HTML_KEY) && "true".equals(String.valueOf(properties.get(INIT_HTML_KEY)))) {
                        ExtentReportsLoader.initHtml(properties);
                    }
                    if (properties.containsKey(INIT_EXCEL_KEY) && "true".equals(String.valueOf(properties.get(INIT_EXCEL_KEY)))) {
                        ExtentReportsLoader.initExcel(properties);
                    }
                    ExtentReportsLoader.addSystemInfo(properties);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private static void createViaSystem() {
            if ("true".equals(System.getProperty(INIT_KLOV_KEY))) {
                ExtentReportsLoader.initKlov(null);
            }
            if ("true".equals(System.getProperty(INIT_SPARK_KEY))) {
                ExtentReportsLoader.initSpark(null);
            }
            if ("true".equals(System.getProperty(INIT_JSONF_KEY))) {
                ExtentReportsLoader.initJsonf(null);
            }
            if ("true".equals(System.getProperty(INIT_PDF_KEY))) {
                ExtentReportsLoader.initPdf(null);
            }
            if ("true".equals(System.getProperty(INIT_HTML_KEY))) {
                ExtentReportsLoader.initHtml(null);
            }
            if ("true".equals(System.getProperty(INIT_EXCEL_KEY))) {
                ExtentReportsLoader.initExcel(null);
            }
            ExtentReportsLoader.addSystemInfo(System.getProperties());
        }

        private static String getBaseFolderName() {
            String folderpattern = "";
            Object baseFolderPrefix = ExtentService.getProperty(REPORTS_BASEFOLDER_NAME);
            Object baseFolderPatternSuffix = ExtentService.getProperty(REPORTS_BASEFOLDER_DATETIMEPATTERN);
            String enableDelimiter = String.valueOf(ExtentService.getPropertyOrDefault(REPORTS_BASEFOLDER_ENABLEDELIMITER, "true"));
            String delimiter = String.valueOf(ExtentService.getPropertyOrDefault(REPORTS_BASEFOLDER_DELIMITER, " "));
            if (enableDelimiter.equalsIgnoreCase("false")) {
                delimiter = "";
            }
            if (baseFolderPrefix != null && !String.valueOf(baseFolderPrefix).isEmpty() && baseFolderPatternSuffix != null && !String.valueOf(baseFolderPatternSuffix).isEmpty()) {
                DateTimeFormatter folderSuffix = DateTimeFormatter.ofPattern(String.valueOf(baseFolderPatternSuffix));
                folderpattern = baseFolderPrefix + delimiter + folderSuffix.format(FOLDER_CURRENT_TIMESTAMP) + "/";
            }
            return folderpattern;
        }

        private static String getOutputPath(Properties properties, String key) {
            String out = properties != null && properties.get(key) != null ? String.valueOf(properties.get(key)) : System.getProperty(key);
            out = out == null || out.equals("null") || out.isEmpty() ? "test-output/" + key.split("\\.")[2] + "/" : out;
            return ExtentReportsLoader.getBaseFolderName() + out;
        }

        private static void configureScreenshotProperties() {
            Object property = ExtentService.getProperty(SCREENSHOT_DIR_PROPERTY);
            SCREENSHOT_FOLDER_NAME = property == null || String.valueOf(property).isEmpty() ? "test-output/" : String.valueOf(property);
            SCREENSHOT_FOLDER_NAME = ExtentReportsLoader.getBaseFolderName() + SCREENSHOT_FOLDER_NAME;
            property = ExtentService.getProperty(SCREENSHOT_REL_PATH_PROPERTY);
            SCREENSHOT_FOLDER_REPORT_RELATIVE_PATH = property == null || String.valueOf(property).isEmpty() ? SCREENSHOT_FOLDER_NAME : String.valueOf(property);
        }

        private static void configureDeviceAndAuthorProperties() {
            String property;
            if ("true".equals(String.valueOf(ExtentService.getPropertyOrDefault(DEVICE_ENABLE_SPARK_KEY, "false")))) {
                IS_DEVICE_ENABLED = true;
            }
            if ("true".equals(String.valueOf(ExtentService.getPropertyOrDefault(AUTHOR_ENABLE_SPARK_KEY, "false")))) {
                IS_AUTHOR_ENABLED = true;
            }
            if (IS_DEVICE_ENABLED && !(property = String.valueOf(ExtentService.getPropertyOrDefault(DEVICE_PREFIX_SPARK_KEY, DEFAULT_DEVICE_PREFIX))).isEmpty()) {
                DEVICE_NAME_PREFIX = property;
            }
            if (IS_AUTHOR_ENABLED && !(property = String.valueOf(ExtentService.getPropertyOrDefault(AUTHOR_PREFIX_SPARK_KEY, DEFAULT_AUTHOR_PREFIX))).isEmpty()) {
                AUTHOR_NAME_PREFIX = property;
            }
        }

        private static void initKlov(Properties properties) {
            ExtentKlovReporter klov = new ExtentKlovReporter("Default");
            String configPath = properties == null ? System.getProperty(CONFIG_KLOV_KEY) : String.valueOf(properties.get(CONFIG_KLOV_KEY));
            File f = new File(configPath);
            if (configPath != null && !configPath.isEmpty() && f.exists()) {
                ExtentReportsLoader.configureScreenshotProperties();
                String url = Paths.get(SCREENSHOT_FOLDER_NAME, new String[0]).toString();
                ExtentService.getInstance().tryResolveMediaPath(new String[]{url});
                try {
                    FileInputStream is = new FileInputStream(f);
                    klov.loadInitializationParams((InputStream)is);
                    INSTANCE.attachReporter(new ExtentObserver[]{klov});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private static void initSpark(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_SPARK_KEY);
            ExtentSparkReporter spark = new ExtentSparkReporter(out);
            ExtentReportsLoader.sparkReportViewOrder(spark);
            ExtentReportsLoader.filterReportStatus(spark);
            ExtentReportsLoader.base64PngImageStyle();
            ExtentReportsLoader.attach((ReporterConfigurable)spark, properties, CONFIG_SPARK_KEY);
        }

        private static void initHtml(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_HTML_KEY);
            ExtentHtmlReporter html = new ExtentHtmlReporter(out);
            ExtentReportsLoader.filterReportStatus(html);
            ExtentReportsLoader.base64PngImageStyle();
            ExtentReportsLoader.attach((ReporterConfigurable)html, properties, CONFIG_HTML_KEY);
        }

        private static void initExcel(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_EXCEL_KEY);
            ExtentExcelCucumberReporter excel = new ExtentExcelCucumberReporter(out);
            INSTANCE.attachReporter(new ExtentObserver[]{excel});
        }

        private static void filterReportStatus(ReporterFilterable<?> reporter) {
            try {
                if (ExtentService.getProperty(STATUS_FILTER_KEY) == null) {
                    return;
                }
                List statuses = Arrays.stream(String.valueOf(ExtentService.getProperty(STATUS_FILTER_KEY)).split(",")).map(s -> ExtentReportsLoader.convertToStatus(s)).collect(Collectors.toList());
                reporter.filter().statusFilter().as(statuses);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void sparkReportViewOrder(ExtentSparkReporter spark) {
            try {
                if (ExtentService.getProperty(VIEW_ORDER_SPARK_KEY) == null) {
                    return;
                }
                List viewOrder = Arrays.stream(String.valueOf(ExtentService.getProperty(VIEW_ORDER_SPARK_KEY)).split(",")).map(v -> ViewName.valueOf((String)v.toUpperCase())).collect(Collectors.toList());
                spark.viewConfigurer().viewOrder().as(viewOrder).apply();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static void base64PngImageStyle() {
            if ("true".equals(String.valueOf(ExtentService.getPropertyOrDefault(BASE64_IMAGE_SRC_SPARK_KEY, "false")))) {
                ENABLE_BASE64_IMAGE_SRC = true;
            }
        }

        private static void initJsonf(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_JSONF_KEY);
            JsonFormatter jsonf = new JsonFormatter(out);
            INSTANCE.attachReporter(new ExtentObserver[]{jsonf});
        }

        private static void initPdf(Properties properties) {
            String out = ExtentReportsLoader.getOutputPath(properties, OUT_PDF_KEY);
            ExtentReportsLoader.configureScreenshotProperties();
            MediaCleanup.MediaCleanupOption mediaCleanup = MediaCleanup.MediaCleanupOption.builder().cleanUpType(MediaCleanup.CleanupType.PATTERN).pattern("base64_generated_pdf_.*").build();
            ExtentPDFCucumberReporter pdf = new ExtentPDFCucumberReporter(out, SCREENSHOT_FOLDER_NAME, mediaCleanup);
            ExtentReportsLoader.filterReportStatus(pdf);
            INSTANCE.attachReporter(new ExtentObserver[]{pdf});
        }

        private static void attach(ReporterConfigurable r, Properties properties, String configKey) {
            Object configPath;
            Object object = configPath = properties == null ? System.getProperty(configKey) : properties.get(configKey);
            if (configPath != null && !String.valueOf(configPath).isEmpty()) {
                try {
                    r.loadXMLConfig(String.valueOf(configPath));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            INSTANCE.attachReporter(new ExtentObserver[]{(ExtentObserver)r});
        }

        private static void addSystemInfo(Properties properties) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = String.valueOf(k);
                if (key.startsWith(SYS_INFO_MARKER)) {
                    key = key.substring(key.indexOf(46) + 1);
                    INSTANCE.setSystemInfo(key, String.valueOf(v));
                }
            }));
        }

        private static Status convertToStatus(String status) {
            String lowerStatus;
            switch (lowerStatus = status.toLowerCase()) {
                case "info": {
                    return Status.INFO;
                }
                case "pass": {
                    return Status.PASS;
                }
                case "Warning": {
                    return Status.WARNING;
                }
                case "skip": {
                    return Status.SKIP;
                }
                case "fail": {
                    return Status.FAIL;
                }
            }
            throw new IllegalArgumentException();
        }

        static {
            FOLDER_CURRENT_TIMESTAMP = LocalDateTime.now();
            IS_DEVICE_ENABLED = false;
            IS_AUTHOR_ENABLED = false;
            ExtentReportsLoader.createViaProperties();
            ExtentReportsLoader.createViaSystem();
            ExtentReportsLoader.configureScreenshotProperties();
            ExtentReportsLoader.configureDeviceAndAuthorProperties();
        }
    }
}

